/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.uml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.statemachine.StateMachineException;
import org.springframework.util.FileCopyUtils;

class ResourcerResolver {
    private ResourceLoader resourceLoader;
    private Resource mainResource;
    private String mainLocation;
    private Resource[] additionalResources;
    private String[] additionalLocations;

    public ResourcerResolver(Resource mainResource, Resource[] additionalResources) {
        this.mainResource = mainResource;
        this.additionalResources = additionalResources != null ? additionalResources : new Resource[]{};
    }

    public ResourcerResolver(ResourceLoader resourceLoader, String mainLocation, String[] additionalLocations) {
        this.resourceLoader = resourceLoader;
        this.mainLocation = mainLocation;
        this.additionalLocations = additionalLocations != null ? additionalLocations : new String[]{};
    }

    public Holder[] resolve() {
        ArrayList holders = new ArrayList();
        if (this.mainLocation != null) {
            Resource[] resources = (Resource[])Stream.concat(Stream.of(this.mainLocation), Stream.of(this.additionalLocations)).map(location -> this.resourceLoader.getResource(location)).toArray(Resource[]::new);
            return this.getResourceUris(resources);
        }
        if (this.mainResource != null) {
            Resource[] resources = (Resource[])Stream.concat(Stream.of(this.mainResource), Stream.of(this.additionalResources)).toArray(Resource[]::new);
            return this.getResourceUris(resources);
        }
        return holders.toArray(new Holder[0]);
    }

    private Holder[] getResourceUris(Resource ... resources) {
        ArrayList<Holder> holders = new ArrayList<Holder>();
        try {
            if (this.allPhysical(resources)) {
                for (Resource resource : resources) {
                    holders.add(new Holder(resource.getFile().toURI()));
                }
            } else {
                Path tempDir = Files.createTempDirectory(null, new FileAttribute[0]);
                for (Resource resource : resources) {
                    if (!(resource instanceof ClassPathResource)) continue;
                    ClassPathResource cpr = (ClassPathResource)resource;
                    File f = new File(tempDir.toFile(), cpr.getPath());
                    f.getParentFile().mkdirs();
                    FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)new FileOutputStream(f));
                    holders.add(new Holder(f.toURI(), f.toPath()));
                }
            }
        }
        catch (IOException e) {
            throw new StateMachineException(e);
        }
        return holders.toArray(new Holder[0]);
    }

    private boolean isPhysical(Resource resource) {
        try {
            resource.getFile();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean allPhysical(Resource ... resources) {
        for (Resource resource : resources) {
            if (this.isPhysical(resource)) continue;
            return false;
        }
        return true;
    }

    static class Holder {
        URI uri;
        Path path;

        public Holder(URI uri) {
            this(uri, null);
        }

        public Holder(URI uri, Path path) {
            this.uri = uri;
            this.path = path;
        }

        public URI getUri() {
            return this.uri;
        }

        public Path getPath() {
            return this.path;
        }
    }
}

