/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.uml;

import java.nio.file.Files;
import java.util.Collection;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.UMLPackage;
import org.springframework.statemachine.config.model.AbstractStateMachineModelFactory;
import org.springframework.statemachine.config.model.DefaultStateMachineModel;
import org.springframework.statemachine.config.model.StateMachineComponentResolver;
import org.springframework.statemachine.config.model.StateMachineModel;
import org.springframework.statemachine.uml.ResourcerResolver;
import org.springframework.statemachine.uml.support.UmlModelParser;
import org.springframework.statemachine.uml.support.UmlUtils;
import org.springframework.util.Assert;

public class UmlStateMachineModelFactory
extends AbstractStateMachineModelFactory<String, String> {
    private org.springframework.core.io.Resource resource;
    private String location;
    private org.springframework.core.io.Resource[] additionalResources;
    private String[] additionalLocations;

    public UmlStateMachineModelFactory(org.springframework.core.io.Resource resource) {
        this(resource, null);
    }

    public UmlStateMachineModelFactory(String location) {
        this(location, null);
    }

    public UmlStateMachineModelFactory(org.springframework.core.io.Resource resource, org.springframework.core.io.Resource[] additionalResources) {
        Assert.notNull((Object)resource, (String)"Resource must be set");
        this.resource = resource;
        this.additionalResources = additionalResources;
    }

    public UmlStateMachineModelFactory(String location, String[] additionalLocations) {
        Assert.notNull((Object)location, (String)"Location must be set");
        this.location = location;
        this.additionalLocations = additionalLocations;
    }

    public StateMachineModel<String, String> build() {
        ResourcerResolver resourceResolver = null;
        if (this.location != null) {
            resourceResolver = new ResourcerResolver(this.getResourceLoader(), this.location, this.additionalLocations);
        } else if (this.resource != null) {
            resourceResolver = new ResourcerResolver(this.resource, this.additionalResources);
        }
        ResourcerResolver.Holder holder = null;
        Model model = null;
        Resource resource = null;
        try {
            ResourcerResolver.Holder[] resources = resourceResolver.resolve();
            holder = resources != null && resources.length > 0 ? resources[0] : null;
            resource = UmlUtils.getResource(holder.uri.getPath());
            model = (Model)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.MODEL);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot build build model from resource " + String.valueOf(resource) + " or location " + this.location, e);
        }
        finally {
            if (holder != null && holder.path != null) {
                try {
                    Files.deleteIfExists(holder.path);
                }
                catch (Exception exception) {}
            }
        }
        UmlModelParser parser = new UmlModelParser(model, (StateMachineComponentResolver<String, String>)this);
        UmlModelParser.DataHolder dataHolder = parser.parseModel();
        if (resource != null) {
            try {
                resource.unload();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (holder != null && holder.path != null) {
            try {
                Files.deleteIfExists(holder.path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DefaultStateMachineModel(null, dataHolder.getStatesData(), dataHolder.getTransitionsData());
    }
}

