/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.uml.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.BodyOwner;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.action.Actions;
import org.springframework.statemachine.action.SpelExpressionAction;
import org.springframework.statemachine.config.model.StateMachineComponentResolver;
import org.springframework.statemachine.transition.TransitionKind;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public abstract class UmlUtils {
    public static Model getModel(String modelPath) {
        URI modelUri = URI.createFileURI((String)modelPath);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/5.0.0/UML", (Object)UMLPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        resourceSet.createResource(modelUri);
        Resource resource = resourceSet.getResource(modelUri, true);
        Model m = (Model)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.MODEL);
        return m;
    }

    public static Resource getResource(String modelPath) {
        URI modelUri = URI.createFileURI((String)modelPath);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/5.0.0/UML", (Object)UMLPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        resourceSet.createResource(modelUri);
        return resourceSet.getResource(modelUri, true);
    }

    public static boolean isInitialState(State state) {
        return UmlUtils.resolveInitialTransition(state) != null;
    }

    public static Transition resolveInitialTransition(State state) {
        for (Transition t : state.getIncomings()) {
            if (!(t.getSource() instanceof Pseudostate) || ((Pseudostate)t.getSource()).getKind() != PseudostateKind.INITIAL_LITERAL) continue;
            return t;
        }
        return null;
    }

    public static Collection<Action<String, String>> resolveTransitionActions(Transition transition, StateMachineComponentResolver<String, String> resolver) {
        ArrayList<Action<String, String>> actions = new ArrayList<Action<String, String>>();
        Action<String, String> action = UmlUtils.resolveTransitionAction(transition, resolver);
        if (action != null) {
            actions.add(action);
        }
        return actions;
    }

    public static Action<String, String> resolveTransitionAction(Transition transition, StateMachineComponentResolver<String, String> resolver) {
        Action action = null;
        if (transition.getEffect() instanceof OpaqueBehavior) {
            String beanId = UmlUtils.resolveBodyByLanguage("bean", (BodyOwner)((OpaqueBehavior)transition.getEffect()));
            if (StringUtils.hasText((String)beanId)) {
                Action bean = resolver.resolveAction(beanId);
                if (bean != null) {
                    action = bean;
                }
            } else {
                String expression = UmlUtils.resolveBodyByLanguage("spel", (BodyOwner)((OpaqueBehavior)transition.getEffect()));
                if (StringUtils.hasText((String)expression)) {
                    SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                    action = new SpelExpressionAction(parser.parseExpression(expression));
                }
            }
        }
        return action;
    }

    public static Collection<Function<StateContext<String, String>, Mono<Void>>> resolveTransitionActionFunctions(Transition transition, StateMachineComponentResolver<String, String> resolver) {
        ArrayList<Function<StateContext<String, String>, Mono<Void>>> actions = new ArrayList<Function<StateContext<String, String>, Mono<Void>>>();
        Function<StateContext<String, String>, Mono<Void>> action = UmlUtils.resolveTransitionActionFunction(transition, resolver);
        if (action != null) {
            actions.add(action);
        }
        return actions;
    }

    public static Function<StateContext<String, String>, Mono<Void>> resolveTransitionActionFunction(Transition transition, StateMachineComponentResolver<String, String> resolver) {
        Action action = null;
        if (transition.getEffect() instanceof OpaqueBehavior) {
            String beanId = UmlUtils.resolveBodyByLanguage("bean", (BodyOwner)((OpaqueBehavior)transition.getEffect()));
            if (StringUtils.hasText((String)beanId)) {
                Action bean = resolver.resolveAction(beanId);
                if (bean != null) {
                    action = bean;
                }
            } else {
                String expression = UmlUtils.resolveBodyByLanguage("spel", (BodyOwner)((OpaqueBehavior)transition.getEffect()));
                if (StringUtils.hasText((String)expression)) {
                    SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                    action = new SpelExpressionAction(parser.parseExpression(expression));
                }
            }
        }
        return Actions.from(action);
    }

    public static boolean isFinalState(State state) {
        return state instanceof FinalState;
    }

    public static String resolveBodyByLanguage(String language, BodyOwner owner) {
        try {
            return ((String)owner.getBodies().get(owner.getLanguages().indexOf((Object)language))).trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Collection<String> resolveDererredEvents(State state) {
        ArrayList<String> events = new ArrayList<String>();
        for (Trigger trigger : state.getDeferrableTriggers()) {
            Event event = trigger.getEvent();
            if (!(event instanceof SignalEvent)) continue;
            Signal signal = ((SignalEvent)event).getSignal();
            events.add(signal.getName());
        }
        return events;
    }

    public static TransitionKind mapUmlTransitionType(Transition transition) {
        org.eclipse.uml2.uml.TransitionKind kind = transition.getKind();
        if (kind == org.eclipse.uml2.uml.TransitionKind.LOCAL_LITERAL) {
            return TransitionKind.LOCAL;
        }
        if (kind == org.eclipse.uml2.uml.TransitionKind.INTERNAL_LITERAL) {
            return TransitionKind.INTERNAL;
        }
        return TransitionKind.EXTERNAL;
    }
}

