/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.binding.mapping.MappingResult;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.MappingResultsCriteria;

public class DefaultMappingResults
implements MappingResults {
    private Object source;
    private Object target;
    private List mappingResults;

    public DefaultMappingResults(Object source, Object target, List mappingResults) {
        this.source = source;
        this.target = target;
        this.mappingResults = mappingResults;
    }

    public Object getSource() {
        return this.source;
    }

    public Object getTarget() {
        return this.target;
    }

    public List getAllResults() {
        return Collections.unmodifiableList(this.mappingResults);
    }

    public boolean hasErrorResults() {
        Iterator it = this.mappingResults.iterator();
        while (it.hasNext()) {
            MappingResult result = (MappingResult)it.next();
            if (!result.isError()) continue;
            return true;
        }
        return false;
    }

    public List getErrorResults() {
        ArrayList<MappingResult> errorResults = new ArrayList<MappingResult>();
        Iterator it = this.mappingResults.iterator();
        while (it.hasNext()) {
            MappingResult result = (MappingResult)it.next();
            if (!result.isError()) continue;
            errorResults.add(result);
        }
        return Collections.unmodifiableList(errorResults);
    }

    public List getResults(MappingResultsCriteria criteria) {
        ArrayList<MappingResult> results = new ArrayList<MappingResult>();
        Iterator it = this.mappingResults.iterator();
        while (it.hasNext()) {
            MappingResult result = (MappingResult)it.next();
            if (!criteria.test(result)) continue;
            results.add(result);
        }
        return Collections.unmodifiableList(results);
    }

    public String toString() {
        return "Mapping Results = " + this.mappingResults.toString();
    }
}

