/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import java.util.Collection;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.core.CollectionFactory;
import org.springframework.core.GenericCollectionTypeResolver;

public class ObjectToCollection
implements Converter {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private ConversionService conversionService;
    private ConversionExecutor elementConverter;

    public ObjectToCollection(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ObjectToCollection(ConversionExecutor elementConverter) {
        this.elementConverter = elementConverter;
    }

    @Override
    public Class<?> getSourceClass() {
        return Object.class;
    }

    @Override
    public Class<?> getTargetClass() {
        return Collection.class;
    }

    @Override
    public Object convertSourceToTargetClass(Object source, Class<?> targetClass) throws Exception {
        if (source == null) {
            return null;
        }
        Collection collection = CollectionFactory.createCollection(targetClass, (int)16);
        ConversionExecutor converter = this.getElementConverter(source, targetClass);
        Object value = converter != null ? converter.execute(source) : source;
        collection.add(value);
        return collection;
    }

    private ConversionExecutor getElementConverter(Object source, Class<? extends Collection<?>> targetClass) {
        if (this.elementConverter != null) {
            return this.elementConverter;
        }
        Class elementType = GenericCollectionTypeResolver.getCollectionType(targetClass);
        if (elementType != null) {
            Class<?> componentType = source.getClass().getComponentType();
            return this.conversionService.getConversionExecutor(componentType, elementType);
        }
        return null;
    }
}

