/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.model;

import java.util.ArrayList;
import java.util.List;
import org.springframework.faces.model.SelectionAware;
import org.springframework.faces.model.SerializableListDataModel;
import org.springframework.util.Assert;

public class ManySelectionTrackingListDataModel
extends SerializableListDataModel
implements SelectionAware {
    private List selections = new ArrayList();

    public ManySelectionTrackingListDataModel() {
    }

    public ManySelectionTrackingListDataModel(List list) {
        super(list);
    }

    public List getSelections() {
        return this.selections;
    }

    public boolean isCurrentRowSelected() {
        return this.selections.contains(this.getRowData());
    }

    public void selectAll() {
        this.selections.clear();
        this.selections.addAll((List)this.getWrappedData());
    }

    public void setCurrentRowSelected(boolean rowSelected) {
        if (!this.isRowAvailable()) {
            return;
        }
        if (rowSelected && !this.selections.contains(this.getRowData())) {
            this.selections.add(this.getRowData());
        } else {
            this.selections.remove(this.getRowData());
        }
    }

    public void setSelections(List selections) {
        this.selections = selections;
    }

    public void select(Object rowData) {
        Assert.isTrue((boolean)((List)this.getWrappedData()).contains(rowData), (String)"The object to select is not contained in this DataModel.");
        if (!this.selections.contains(rowData)) {
            this.selections.add(rowData);
        }
    }
}

