/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.model;

import java.util.ArrayList;
import java.util.List;
import org.springframework.faces.model.SelectionAware;
import org.springframework.faces.model.SerializableListDataModel;
import org.springframework.util.Assert;

public class OneSelectionTrackingListDataModel
extends SerializableListDataModel
implements SelectionAware {
    private List selections = new ArrayList();

    public OneSelectionTrackingListDataModel() {
    }

    public OneSelectionTrackingListDataModel(List list) {
        super(list);
    }

    public List getSelections() {
        return this.selections;
    }

    public boolean isCurrentRowSelected() {
        return this.selections.contains(this.getRowData());
    }

    public void select(Object rowData) {
        Assert.isTrue((boolean)((List)this.getWrappedData()).contains(rowData), (String)"The object to select is not contained in this DataModel.");
        this.selections.clear();
        this.selections.add(rowData);
    }

    public void selectAll() {
        if (((List)this.getWrappedData()).size() > 1) {
            throw new UnsupportedOperationException("This DataModel only allows one selection.");
        }
    }

    public void setCurrentRowSelected(boolean rowSelected) {
        if (!this.isRowAvailable()) {
            return;
        }
        if (!rowSelected) {
            this.selections.clear();
        } else if (rowSelected && !this.selections.contains(this.getRowData())) {
            this.selections.clear();
            this.selections.add(this.getRowData());
        }
    }

    public void setSelections(List selections) {
        Assert.isTrue((selections.size() <= 1 ? 1 : 0) != 0, (String)"This DataModel only allows one selection.");
        this.selections = selections;
    }

    public Object getSelectedRow() {
        if (this.selections.size() == 1) {
            return this.selections.get(0);
        }
        return null;
    }
}

