/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.springframework.faces.ui.DelegatingViewRoot;
import org.springframework.faces.ui.resource.ResourceHelper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AjaxViewRoot
extends DelegatingViewRoot {
    public static final String AJAX_SOURCE_PARAM = "ajaxSource";
    public static final String PROCESS_IDS_PARAM = "processIds";
    protected static final String FORM_RENDERED = "formRendered";
    protected static final String PROCESS_ALL = "*";
    private List events = new ArrayList();
    private String[] processIds;
    private String[] renderIds;
    private static final String RENDER_IDS_EXPRESSION = "#{flowRenderFragments}";
    private final ValueBinding renderIdsExpr = FacesContext.getCurrentInstance().getApplication().createValueBinding("#{flowRenderFragments}");

    public AjaxViewRoot(UIViewRoot original) {
        super(original);
        original.setId(this.createUniqueId());
        this.swapChildren(original, this);
        this.setId(String.valueOf(original.getId()) + "_ajax");
    }

    public void queueEvent(FacesEvent event) {
        Assert.notNull((Object)event, (String)"Cannot queue a null event.");
        this.events.add(event);
    }

    public void encodeAll(FacesContext context) throws IOException {
        int i = 0;
        while (i < this.getRenderIds().length) {
            String renderId = this.getRenderIds()[i];
            ContextCallback callback = new ContextCallback(){

                public void invokeContextCallback(FacesContext context, UIComponent target) {
                    try {
                        target.encodeAll(context);
                        if (target instanceof UIForm) {
                            context.getViewRoot().getAttributes().put(AjaxViewRoot.FORM_RENDERED, AjaxViewRoot.FORM_RENDERED);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.invokeOnComponent(context, renderId, callback);
            ++i;
        }
        this.swapChildren(this, this.getOriginalViewRoot());
        context.setViewRoot(this.getOriginalViewRoot());
        if (!this.getAttributes().containsKey(FORM_RENDERED)) {
            context.getApplication().getViewHandler().writeState(context);
            this.updateFormAction(context);
        }
        this.broadCastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
    }

    public void processDecodes(FacesContext context) {
        int i = 0;
        while (i < this.getProcessIds().length) {
            String processId = this.getProcessIds()[i];
            ContextCallback callback = new ContextCallback(){

                public void invokeContextCallback(FacesContext context, UIComponent target) {
                    target.processDecodes(context);
                }
            };
            this.invokeOnComponent(context, processId, callback);
            ++i;
        }
        this.broadCastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
    }

    public void processUpdates(FacesContext context) {
        int i = 0;
        while (i < this.getProcessIds().length) {
            String processId = this.getProcessIds()[i];
            ContextCallback callback = new ContextCallback(){

                public void invokeContextCallback(FacesContext context, UIComponent target) {
                    target.processUpdates(context);
                }
            };
            this.invokeOnComponent(context, processId, callback);
            ++i;
        }
        this.broadCastEvents(context, PhaseId.UPDATE_MODEL_VALUES);
    }

    public void processValidators(FacesContext context) {
        int i = 0;
        while (i < this.getProcessIds().length) {
            String processId = this.getProcessIds()[i];
            ContextCallback callback = new ContextCallback(){

                public void invokeContextCallback(FacesContext context, UIComponent target) {
                    target.processValidators(context);
                }
            };
            this.invokeOnComponent(context, processId, callback);
            ++i;
        }
        this.broadCastEvents(context, PhaseId.PROCESS_VALIDATIONS);
    }

    public void processApplication(FacesContext context) {
        this.broadCastEvents(context, PhaseId.INVOKE_APPLICATION);
    }

    protected String[] getProcessIds() {
        if (this.processIds == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            String processIdsParam = (String)context.getExternalContext().getRequestParameterMap().get(PROCESS_IDS_PARAM);
            if (StringUtils.hasText((String)processIdsParam) && processIdsParam.indexOf(PROCESS_ALL) != -1) {
                this.processIds = new String[]{this.getOriginalViewRoot().getClientId(context)};
            } else {
                this.processIds = StringUtils.delimitedListToStringArray((String)processIdsParam, (String)",", (String)" ");
                this.processIds = this.removeNestedChildren(context, this.processIds);
            }
        }
        return this.processIds;
    }

    protected String[] getRenderIds() {
        if (this.renderIds == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.renderIds = (String[])this.renderIdsExpr.getValue(context);
            this.renderIds = this.renderIds == null || this.renderIds.length == 0 ? this.getProcessIds() : this.removeNestedChildren(context, this.renderIds);
        }
        return this.renderIds;
    }

    private void swapChildren(UIViewRoot source, UIViewRoot target) {
        target.getChildren().addAll(source.getChildren());
        Iterator i = target.getChildren().iterator();
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            child.setParent((UIComponent)target);
        }
    }

    private void updateFormAction(FacesContext context) {
        ResponseWriter writer = context.getResponseWriter();
        try {
            String formId = this.findContainingFormId(context);
            if (StringUtils.hasLength((String)formId)) {
                String script = "dojo.byId('" + formId + "').action = '" + context.getApplication().getViewHandler().getActionURL(context, this.getViewId()) + "'";
                ResourceHelper.beginScriptBlock(context);
                writer.writeText((Object)script, null);
                ResourceHelper.endScriptBlock(context);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String findContainingFormId(FacesContext context) {
        int i = 0;
        while (i < this.getRenderIds().length) {
            UIComponent component = context.getViewRoot().findComponent(this.getRenderIds()[i]);
            Assert.notNull((Object)component, (String)("Component to be rendered with id '" + this.getRenderIds()[i] + "' could not be found."));
            while (!(component instanceof UIViewRoot)) {
                if (!((component = component.getParent()) instanceof UIForm)) continue;
                return component.getClientId(context);
            }
            ++i;
        }
        return null;
    }

    private String[] removeNestedChildren(FacesContext context, String[] ids) {
        List<String> idList = Arrays.asList(ids);
        final ArrayList<String> trimmedIds = new ArrayList<String>(idList);
        final ListIterator i = trimmedIds.listIterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            this.invokeOnComponent(context, id, new ContextCallback(){

                public void invokeContextCallback(FacesContext context, UIComponent component) {
                    while (!(component.getParent() instanceof UIViewRoot)) {
                        if (!trimmedIds.contains((component = component.getParent()).getClientId(context))) continue;
                        i.remove();
                    }
                }
            });
        }
        return trimmedIds.toArray(new String[trimmedIds.size()]);
    }

    private void broadCastEvents(FacesContext context, PhaseId phaseId) {
        ArrayList<FacesEvent> processedEvents = new ArrayList<FacesEvent>();
        if (this.events.size() == 0) {
            return;
        }
        boolean abort = false;
        int phaseIdOrdinal = phaseId.getOrdinal();
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            FacesEvent event = (FacesEvent)i.next();
            int ordinal = event.getPhaseId().getOrdinal();
            if (ordinal != PhaseId.ANY_PHASE.getOrdinal() && ordinal != phaseIdOrdinal) continue;
            UIComponent source = event.getComponent();
            try {
                processedEvents.add(event);
                source.broadcast(event);
            }
            catch (AbortProcessingException abortProcessingException) {
                abort = true;
                break;
            }
        }
        if (abort) {
            this.events.clear();
        } else {
            this.events.removeAll(processedEvents);
        }
    }
}

