/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.richfaces;

import java.io.IOException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.context.AjaxContext;
import org.springframework.faces.webflow.FlowLifecycle;
import org.springframework.js.ajax.AjaxHandler;
import org.springframework.js.ajax.SpringJavascriptAjaxHandler;
import org.springframework.util.Assert;
import org.springframework.web.context.support.WebApplicationObjectSupport;

public class RichFacesAjaxHandler
extends WebApplicationObjectSupport
implements AjaxHandler {
    private AjaxHandler delegate = new SpringJavascriptAjaxHandler();

    public boolean isAjaxRequest(HttpServletRequest request, HttpServletResponse response) {
        if (this.isRichFacesAjaxRequest(request, response)) {
            return true;
        }
        return this.delegate.isAjaxRequest(request, response);
    }

    public void sendAjaxRedirect(String targetUrl, HttpServletRequest request, HttpServletResponse response, boolean popup) throws IOException {
        if (this.isRichFacesAjaxRequest(request, response)) {
            response.sendRedirect(response.encodeRedirectURL(targetUrl));
        } else {
            this.delegate.sendAjaxRedirect(targetUrl, request, response, popup);
        }
    }

    protected boolean isRichFacesAjaxRequest(HttpServletRequest request, HttpServletResponse response) {
        FacesContextHelper helper = new FacesContextHelper();
        try {
            FacesContext facesContext = helper.getFacesContext(this.getServletContext(), request, response);
            AjaxContext context = AjaxContext.getCurrentInstance((FacesContext)facesContext);
            if (context != null) {
                boolean bl = context.isAjaxRequest(facesContext);
                return bl;
            }
            return false;
        }
        finally {
            helper.cleanup();
        }
    }

    private static class FacesContextHelper {
        private boolean created = false;

        private FacesContextHelper() {
        }

        protected FacesContext getFacesContext(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
            if (FacesContext.getCurrentInstance() != null) {
                return FacesContext.getCurrentInstance();
            }
            FacesContextFactory facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            FacesContext defaultFacesContext = facesContextFactory.getFacesContext((Object)context, (Object)request, (Object)response, FlowLifecycle.newInstance());
            Assert.notNull((Object)defaultFacesContext, (String)"Creation of the default FacesContext failed.");
            this.created = true;
            return defaultFacesContext;
        }

        protected void cleanup() {
            if (this.created) {
                FacesContext.getCurrentInstance().release();
            }
        }
    }
}

