/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow.application.portlet;

import com.sun.facelets.FaceletViewHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.portlet.RenderResponse;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PortletFaceletViewHandler
extends FaceletViewHandler {
    private static final String FACELETS_CONTENT_TYPE_KEY = "facelets.ContentType";
    private static final String FACELETS_ENCODING_KEY = "facelets.Encoding";

    public PortletFaceletViewHandler(ViewHandler parent) {
        super(parent);
    }

    protected ResponseWriter createResponseWriter(FacesContext context) throws IOException, FacesException {
        if (!JsfRuntimeInformation.isPortletRequest(context)) {
            return super.createResponseWriter(context);
        }
        ResponseWriter writer = this.createNoopResponseWriter(context);
        RenderResponse response = (RenderResponse)context.getExternalContext().getResponse();
        String contentType = this.getResponseContentType(context, writer.getContentType());
        String encoding = this.getResponseEncoding(context, writer.getCharacterEncoding());
        response.setContentType(String.valueOf(contentType) + "; charset=" + encoding);
        return writer.cloneWithWriter((Writer)response.getWriter());
    }

    private ResponseWriter createNoopResponseWriter(FacesContext context) {
        ResponseWriter writer;
        RenderKit renderKit = context.getRenderKit();
        Assert.notNull((Object)renderKit, (String)context.getViewRoot().getRenderKitId());
        String contentType = (String)context.getExternalContext().getRequestMap().get(FACELETS_CONTENT_TYPE_KEY);
        if (StringUtils.hasText((String)contentType) && !contentType.equals("*/*")) {
            contentType = String.valueOf(contentType) + ",*/*";
        }
        String encoding = (String)context.getExternalContext().getRequestMap().get(FACELETS_ENCODING_KEY);
        try {
            writer = renderKit.createResponseWriter((Writer)NoopWriter.INSTANCE, contentType, encoding);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.fine("The impl didn't correctly handle '*/*' in the content type list.. try '*/*' directly.");
            writer = renderKit.createResponseWriter((Writer)NoopWriter.INSTANCE, "*/*", encoding);
        }
        return writer;
    }

    protected String getResponseEncoding(FacesContext context, String originalEncoding) {
        String encoding = originalEncoding;
        Map requestMap = context.getExternalContext().getRequestMap();
        Map sessionMap = context.getExternalContext().getSessionMap();
        if (requestMap.containsKey(FACELETS_ENCODING_KEY)) {
            encoding = (String)requestMap.get(FACELETS_ENCODING_KEY);
            sessionMap.put("javax.faces.request.charset", encoding);
        }
        if (encoding == null) {
            encoding = context.getExternalContext().getResponseCharacterEncoding();
        }
        if (encoding == null) {
            encoding = (String)sessionMap.get("javax.faces.request.charset");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    protected static class NoopWriter
    extends Writer {
        static final NoopWriter INSTANCE = new NoopWriter();

        protected NoopWriter() {
        }

        public void write(char[] buffer) {
        }

        public void write(char[] buffer, int off, int len) {
        }

        public void write(String str) {
        }

        public void write(int c) {
        }

        public void write(String str, int off, int len) {
        }

        public void close() {
        }

        public void flush() {
        }
    }
}

