/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow.context.portlet;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.springframework.faces.webflow.context.portlet.PortletExternalContextImpl;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletFacesContextImpl
extends FacesContext {
    private Application application;
    private ELContext elContext;
    private ExternalContext externalContext;
    private FacesMessage.Severity maximumSeverity;
    private List<String> messageClientIds;
    private List<FacesMessage> messages;
    private boolean released = false;
    private RenderKitFactory renderKitFactory;
    private boolean renderResponse = false;
    private boolean responseComplete = false;
    private ResponseStream responseStream;
    private ResponseWriter responseWriter;
    private UIViewRoot viewRoot;

    public PortletFacesContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        this.application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        this.renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this.externalContext = new PortletExternalContextImpl(portletContext, portletRequest, portletResponse);
        FacesContext.setCurrentInstance((FacesContext)this);
    }

    public PortletFacesContextImpl(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    public ExternalContext getExternalContext() {
        this.assertFacesContextIsNotReleased();
        return this.externalContext;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        this.assertFacesContextIsNotReleased();
        return this.maximumSeverity;
    }

    public Iterator<FacesMessage> getMessages() {
        this.assertFacesContextIsNotReleased();
        return this.messages != null ? this.messages.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public Application getApplication() {
        this.assertFacesContextIsNotReleased();
        return this.application;
    }

    public Iterator<String> getClientIdsWithMessages() {
        this.assertFacesContextIsNotReleased();
        if (this.messages == null || this.messages.isEmpty()) {
            return new ArrayList().iterator();
        }
        return new LinkedHashSet<String>(this.messageClientIds).iterator();
    }

    public Iterator<FacesMessage> getMessages(String clientId) {
        this.assertFacesContextIsNotReleased();
        if (this.messages == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList<FacesMessage> list = new ArrayList<FacesMessage>();
        int i = 0;
        while (i < this.messages.size()) {
            String current = this.messageClientIds.get(i);
            if (clientId == null) {
                if (current == null) {
                    list.add(this.messages.get(i));
                }
            } else if (clientId.equals(current)) {
                list.add(this.messages.get(i));
            }
            ++i;
        }
        return list.iterator();
    }

    public RenderKit getRenderKit() {
        if (this.getViewRoot() == null) {
            return null;
        }
        String renderKitId = this.getViewRoot().getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        return this.renderKitFactory.getRenderKit((FacesContext)this, renderKitId);
    }

    public boolean getRenderResponse() {
        this.assertFacesContextIsNotReleased();
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        this.assertFacesContextIsNotReleased();
        return this.responseComplete;
    }

    public ResponseStream getResponseStream() {
        this.assertFacesContextIsNotReleased();
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.assertFacesContextIsNotReleased();
        if (responseStream == null) {
            throw new NullPointerException("responseStream");
        }
        this.responseStream = responseStream;
    }

    public ResponseWriter getResponseWriter() {
        this.assertFacesContextIsNotReleased();
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.assertFacesContextIsNotReleased();
        if (responseWriter == null) {
            throw new NullPointerException("responseWriter");
        }
        this.responseWriter = responseWriter;
    }

    public UIViewRoot getViewRoot() {
        this.assertFacesContextIsNotReleased();
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        this.assertFacesContextIsNotReleased();
        if (viewRoot == null) {
            throw new NullPointerException("viewRoot");
        }
        this.viewRoot = viewRoot;
    }

    public void addMessage(String clientId, FacesMessage message) {
        this.assertFacesContextIsNotReleased();
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this.messages == null) {
            this.messages = new ArrayList<FacesMessage>();
            this.messageClientIds = new ArrayList<String>();
        }
        this.messages.add(message);
        this.messageClientIds.add(clientId != null ? clientId : null);
        FacesMessage.Severity severity = message.getSeverity();
        if (severity != null) {
            if (this.maximumSeverity == null) {
                this.maximumSeverity = severity;
            } else if (severity.compareTo((Object)this.maximumSeverity) > 0) {
                this.maximumSeverity = severity;
            }
        }
    }

    public void release() {
        Method delegateMethod;
        this.assertFacesContextIsNotReleased();
        if (this.externalContext != null && (delegateMethod = ClassUtils.getMethodIfAvailable(this.externalContext.getClass(), (String)"release", (Class[])new Class[0])) != null) {
            try {
                delegateMethod.invoke((Object)this.externalContext, new Object[0]);
            }
            catch (Exception e) {
                this.externalContext.log("Failed to release external context", (Throwable)e);
            }
            this.externalContext = null;
        }
        this.messageClientIds = null;
        this.messages = null;
        this.application = null;
        this.responseStream = null;
        this.responseWriter = null;
        this.viewRoot = null;
        this.released = true;
        FacesContext.setCurrentInstance(null);
    }

    public void renderResponse() {
        this.assertFacesContextIsNotReleased();
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.assertFacesContextIsNotReleased();
        this.responseComplete = true;
    }

    public ELContext getELContext() {
        if (this.elContext == null) {
            ELContextListener[] listeners;
            Application application = this.getApplication();
            this.elContext = new PortletELContextImpl(application.getELResolver());
            this.elContext.putContext(FacesContext.class, (Object)FacesContext.getCurrentInstance());
            UIViewRoot root = this.getViewRoot();
            if (root != null) {
                this.elContext.setLocale(root.getLocale());
            }
            if ((listeners = application.getELContextListeners()).length > 0) {
                ELContextEvent event = new ELContextEvent(this.elContext);
                ELContextListener[] eLContextListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    ELContextListener listener = eLContextListenerArray[n2];
                    listener.contextCreated(event);
                    ++n2;
                }
            }
        }
        return this.elContext;
    }

    private void assertFacesContextIsNotReleased() {
        Assert.isTrue((!this.released ? 1 : 0) != 0, (String)"FacesContext already released");
    }

    private class PortletELContextImpl
    extends ELContext {
        private FunctionMapper functionMapper;
        private VariableMapper variableMapper;
        private ELResolver resolver;

        public PortletELContextImpl(ELResolver resolver) {
            this.resolver = resolver;
        }

        public FunctionMapper getFunctionMapper() {
            return this.functionMapper;
        }

        public VariableMapper getVariableMapper() {
            return this.variableMapper;
        }

        public ELResolver getELResolver() {
            return this.resolver;
        }
    }
}

