/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.springframework.webflow.execution.RequestContextHolder;

public class JsfUtils {
    public static void notifyAfterListeners(PhaseId phaseId, Lifecycle lifecycle, FacesContext context) {
        PhaseEvent afterPhaseEvent = new PhaseEvent(context, phaseId, lifecycle);
        for (int i = lifecycle.getPhaseListeners().length - 1; i >= 0; --i) {
            PhaseListener listener = lifecycle.getPhaseListeners()[i];
            if (listener.getPhaseId() != phaseId && listener.getPhaseId() != PhaseId.ANY_PHASE) continue;
            listener.afterPhase(afterPhaseEvent);
        }
    }

    public static void notifyBeforeListeners(PhaseId phaseId, Lifecycle lifecycle, FacesContext context) {
        PhaseEvent beforePhaseEvent = new PhaseEvent(context, phaseId, lifecycle);
        for (int i = 0; i < lifecycle.getPhaseListeners().length; ++i) {
            PhaseListener listener = lifecycle.getPhaseListeners()[i];
            if (listener.getPhaseId() != phaseId && listener.getPhaseId() != PhaseId.ANY_PHASE) continue;
            listener.beforePhase(beforePhaseEvent);
        }
    }

    public static boolean isFlowRequest() {
        return RequestContextHolder.getRequestContext() != null;
    }

    public static boolean isAsynchronousFlowRequest() {
        return JsfUtils.isFlowRequest() && RequestContextHolder.getRequestContext().getExternalContext().isAjaxRequest();
    }
}

