/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.model;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.faces.model.SelectionAware;
import org.springframework.faces.webflow.FlowActionListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class SelectionTrackingActionListener
implements ActionListener {
    private static final Method NO_MATCH = ClassUtils.getMethodIfAvailable(System.class, (String)"currentTimeMillis", (Class[])null);
    private static final Log logger = LogFactory.getLog(FlowActionListener.class);
    private final ActionListener delegate;
    private final Map<Class<?>, Method> valueMethodCache = new ConcurrentHashMap(256);

    public SelectionTrackingActionListener(ActionListener delegate) {
        this.delegate = delegate;
    }

    public void processAction(ActionEvent event) throws AbortProcessingException {
        this.trackSelection(event.getComponent());
        this.delegate.processAction(event);
    }

    private void trackSelection(UIComponent component) {
        UIComponent currentComponent = component;
        while (currentComponent.getParent() != null && !(currentComponent.getParent() instanceof UIViewRoot)) {
            Object value;
            UIComponent parent = currentComponent.getParent();
            Method valueAccessor = this.getValueMethod(parent.getClass());
            if (valueAccessor != null && (value = ReflectionUtils.invokeMethod((Method)valueAccessor, (Object)parent)) != null && value instanceof SelectionAware) {
                ((SelectionAware)value).setCurrentRowSelected(true);
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)"Row selection has been set on the current SelectionAware data model.");
                break;
            }
            currentComponent = currentComponent.getParent();
        }
    }

    private Method getValueMethod(Class<?> parentClass) {
        Method method = this.valueMethodCache.get(parentClass);
        if (method == null) {
            method = ReflectionUtils.findMethod(parentClass, (String)"getValue");
            this.valueMethodCache.put(parentClass, method != null ? method : NO_MATCH);
        }
        return method != NO_MATCH ? method : null;
    }
}

