/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.webflow.execution.RequestContext;

public class JsfRuntimeInformation {
    @Deprecated
    public static final int JSF_11 = 0;
    @Deprecated
    public static final int JSF_12 = 1;
    public static final int JSF_20 = 2;
    public static final int JSF_21 = 3;
    public static final int JSF_22 = 4;
    private static final int jsfVersion;
    private static final ClassLoader CLASS_LOADER;
    private static final boolean myFacesPresent;
    private static final boolean myFacesInUse;
    private static boolean portletPresent;
    private static boolean springPortletPresent;

    private static boolean checkMyFacesContextFactory() {
        ClassLoader classLoader = JsfUtils.class.getClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass("org.apache.myfaces.context.FacesContextFactoryImpl");
            Object factory = FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            return clazz.isInstance(factory);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isAtLeastJsf22() {
        return jsfVersion >= 4;
    }

    public static boolean isAtLeastJsf21() {
        return jsfVersion >= 3;
    }

    @Deprecated
    public static boolean isAtLeastJsf20() {
        return jsfVersion >= 2;
    }

    @Deprecated
    public static boolean isAtLeastJsf12() {
        return jsfVersion >= 1;
    }

    @Deprecated
    public static boolean isLessThanJsf20() {
        return jsfVersion < 2;
    }

    public static boolean isMyFacesPresent() {
        return myFacesPresent;
    }

    public static boolean isMyFacesInUse() {
        return myFacesInUse;
    }

    public static boolean isSpringPortletPresent() {
        return portletPresent && springPortletPresent;
    }

    public static boolean isPortletRequest(FacesContext context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        return JsfRuntimeInformation.isPortletContext(context.getExternalContext().getContext());
    }

    public static boolean isPortletRequest(RequestContext context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        return JsfRuntimeInformation.isPortletContext(context.getExternalContext().getNativeContext());
    }

    public static boolean isPortletContext(Object nativeContext) {
        Assert.notNull((Object)nativeContext, (String)"Context must not be null");
        return ClassUtils.getMethodIfAvailable(nativeContext.getClass(), (String)"getPortletContextName", (Class[])new Class[0]) != null;
    }

    static {
        CLASS_LOADER = JsfUtils.class.getClassLoader();
        myFacesPresent = ClassUtils.isPresent((String)"org.apache.myfaces.webapp.MyFacesServlet", (ClassLoader)CLASS_LOADER);
        myFacesInUse = JsfRuntimeInformation.checkMyFacesContextFactory();
        portletPresent = ClassUtils.isPresent((String)"javax.portlet.Portlet", (ClassLoader)CLASS_LOADER);
        springPortletPresent = ClassUtils.isPresent((String)"org.springframework.web.portlet.DispatcherPortlet", (ClassLoader)CLASS_LOADER);
        jsfVersion = ReflectionUtils.findMethod(FacesContext.class, (String)"getResourceLibraryContracts") != null ? 4 : (ReflectionUtils.findMethod(FacesContext.class, (String)"isReleased") != null ? 3 : (ReflectionUtils.findMethod(FacesContext.class, (String)"isPostback") != null ? 2 : (ReflectionUtils.findMethod(FacesContext.class, (String)"getELContext") != null ? 1 : 0)));
    }
}

