/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.mvc;

import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.faces.webflow.FacesContextHelper;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class JsfView
extends AbstractUrlBasedView {
    private Lifecycle facesLifecycle;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.facesLifecycle = this.createFacesLifecycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FacesContextHelper facesContextHelper = new FacesContextHelper();
        FacesContext facesContext = facesContextHelper.getFacesContext(this.getServletContext(), request, response);
        this.populateRequestMap(facesContext, model);
        JsfUtils.notifyBeforeListeners(PhaseId.RESTORE_VIEW, this.facesLifecycle, facesContext);
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        if (!JsfRuntimeInformation.isPortletRequest(facesContext)) {
            viewHandler.initView(facesContext);
        }
        UIViewRoot viewRoot = viewHandler.createView(facesContext, this.getUrl());
        Assert.notNull((Object)viewRoot, (String)("A JSF view could not be created for " + this.getUrl()));
        viewRoot.setLocale(RequestContextUtils.getLocale((HttpServletRequest)request));
        viewRoot.setTransient(true);
        facesContext.setViewRoot(viewRoot);
        JsfUtils.notifyAfterListeners(PhaseId.RESTORE_VIEW, this.facesLifecycle, facesContext);
        facesContext.setViewRoot(viewRoot);
        facesContext.renderResponse();
        try {
            this.logger.debug((Object)"Asking faces lifecycle to render");
            this.facesLifecycle.render(facesContext);
        }
        finally {
            this.logger.debug((Object)"View rendering complete");
            facesContextHelper.releaseIfNecessary();
        }
    }

    private void populateRequestMap(FacesContext facesContext, Map<String, Object> model) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            requestMap.put(entry.getKey(), entry.getValue());
        }
    }

    private Lifecycle createFacesLifecycle() {
        LifecycleFactory lifecycleFactory = JsfUtils.findFactory(LifecycleFactory.class);
        return lifecycleFactory.getLifecycle("DEFAULT");
    }
}

