/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.el.SpringBeanELResolver;
import org.springframework.beans.factory.support.StaticListableBeanFactory;
import org.springframework.binding.expression.el.MapAdaptableELResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.expression.el.FlowResourceELResolver;
import org.springframework.webflow.expression.el.ImplicitFlowVariableELResolver;
import org.springframework.webflow.expression.el.RequestContextELResolver;
import org.springframework.webflow.expression.el.ScopeSearchingELResolver;

public class FlowELResolver
extends CompositeELResolver {
    public FlowELResolver() {
        this.add((ELResolver)new RequestContextELResolver());
        this.add((ELResolver)new ImplicitFlowVariableELResolver());
        this.add((ELResolver)new FlowResourceELResolver());
        this.add((ELResolver)new ScopeSearchingELResolver());
        this.add((ELResolver)new MapAdaptableELResolver());
        this.add((ELResolver)new BeanELResolver());
    }

    private static class BeanELResolver
    extends SpringBeanELResolver {
        private static final BeanFactory EMPTY_BEAN_FACTORY = new StaticListableBeanFactory();

        private BeanELResolver() {
        }

        protected BeanFactory getBeanFactory(ELContext elContext) {
            RequestContext requestContext = RequestContextHolder.getRequestContext();
            if (requestContext == null) {
                return EMPTY_BEAN_FACTORY;
            }
            ApplicationContext beanFactory = requestContext.getActiveFlow().getApplicationContext();
            return beanFactory != null ? beanFactory : EMPTY_BEAN_FACTORY;
        }
    }
}

