/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.lifecycle.Lifecycle;
import org.springframework.binding.message.Message;
import org.springframework.binding.message.MessageCriteria;
import org.springframework.binding.message.MessageResolver;
import org.springframework.binding.message.Severity;
import org.springframework.context.MessageSource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.faces.webflow.FacesContextHelper;
import org.springframework.faces.webflow.FlowExternalContext;
import org.springframework.faces.webflow.FlowPartialViewContext;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.execution.RequestContext;

public class FlowFacesContext
extends FacesContextWrapper {
    static final String RENDER_RESPONSE_KEY = "flowRenderResponse";
    private static final Map<Severity, FacesMessage.Severity> SPRING_SEVERITY_TO_FACES = new HashMap<Severity, FacesMessage.Severity>();
    private static final Map<FacesMessage.Severity, Severity> FACES_SEVERITY_TO_SPRING;
    private final FacesContext wrapped;
    private final RequestContext context;
    private final ExternalContext externalContext;
    private final PartialViewContext partialViewContext;
    private boolean viewRootHolderFromFlashScope;

    public FlowFacesContext(RequestContext context, FacesContext wrapped) {
        this.context = context;
        this.wrapped = wrapped;
        this.externalContext = new FlowExternalContext(context, wrapped.getExternalContext());
        PartialViewContextFactory factory = JsfUtils.findFactory(PartialViewContextFactory.class);
        PartialViewContext partialViewContextDelegate = factory.getPartialViewContext((FacesContext)this);
        this.partialViewContext = new FlowPartialViewContext(partialViewContextDelegate);
        FlowFacesContext.setCurrentInstance((FacesContext)this);
    }

    public FacesContext getWrapped() {
        return this.wrapped;
    }

    public void release() {
        super.release();
        FlowFacesContext.setCurrentInstance(null);
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public PartialViewContext getPartialViewContext() {
        return this.partialViewContext;
    }

    public ELContext getELContext() {
        ELContext elContext = super.getELContext();
        elContext.putContext(FacesContext.class, (Object)this);
        return elContext;
    }

    public boolean getRenderResponse() {
        Boolean renderResponse = this.context.getFlashScope().getBoolean(RENDER_RESPONSE_KEY);
        return renderResponse == null ? false : renderResponse;
    }

    public boolean getResponseComplete() {
        return this.context.getExternalContext().isResponseComplete();
    }

    public void renderResponse() {
        this.context.getFlashScope().put(RENDER_RESPONSE_KEY, (Object)true);
    }

    public void responseComplete() {
        this.context.getExternalContext().recordResponseComplete();
    }

    public boolean isValidationFailed() {
        if (this.context.getMessageContext().hasErrorMessages()) {
            return true;
        }
        return super.isValidationFailed();
    }

    public void addMessage(String clientId, FacesMessage message) {
        FacesMessageSource source = new FacesMessageSource(clientId);
        FlowFacesMessage flowFacesMessage = new FlowFacesMessage(source, message);
        this.context.getMessageContext().addMessage((MessageResolver)flowFacesMessage);
    }

    public Iterator<String> getClientIdsWithMessages() {
        LinkedHashSet<String> clientIds = new LinkedHashSet<String>();
        for (Message message : this.context.getMessageContext().getAllMessages()) {
            Object source = message.getSource();
            if (source != null && source instanceof String) {
                clientIds.add((String)source);
                continue;
            }
            if (!(message.getSource() instanceof FacesMessageSource)) continue;
            clientIds.add(((FacesMessageSource)source).getClientId());
        }
        return Collections.unmodifiableSet(clientIds).iterator();
    }

    public FacesMessage.Severity getMaximumSeverity() {
        if (this.context.getMessageContext().getAllMessages().length == 0) {
            return null;
        }
        FacesMessage.Severity max = FacesMessage.SEVERITY_INFO;
        Iterator<FacesMessage> messages = this.getMessages();
        while (messages.hasNext()) {
            FacesMessage message = messages.next();
            if (message.getSeverity().getOrdinal() > max.getOrdinal()) {
                max = message.getSeverity();
            }
            if (max.getOrdinal() != FacesMessage.SEVERITY_FATAL.getOrdinal()) continue;
            break;
        }
        return max;
    }

    public Iterator<FacesMessage> getMessages() {
        return this.getMessageList().iterator();
    }

    public List<FacesMessage> getMessageList() {
        Message[] messages = this.context.getMessageContext().getAllMessages();
        return this.asFacesMessages(messages);
    }

    public Iterator<FacesMessage> getMessages(String clientId) {
        return this.getMessageList(clientId).iterator();
    }

    public List<FacesMessage> getMessageList(final String clientId) {
        final FacesMessageSource source = new FacesMessageSource(clientId);
        Message[] messages = this.context.getMessageContext().getMessagesByCriteria(new MessageCriteria(){

            public boolean test(Message message) {
                return ObjectUtils.nullSafeEquals((Object)message.getSource(), (Object)source) || ObjectUtils.nullSafeEquals((Object)message.getSource(), (Object)clientId);
            }
        });
        return this.asFacesMessages(messages);
    }

    private List<FacesMessage> asFacesMessages(Message[] messages) {
        if (messages == null || messages.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FacesMessage> facesMessages = new ArrayList<FacesMessage>();
        for (Message message : messages) {
            facesMessages.add(this.asFacesMessage(message));
        }
        return Collections.unmodifiableList(facesMessages);
    }

    private FacesMessage asFacesMessage(Message message) {
        if (message instanceof FlowFacesMessage) {
            return ((FlowFacesMessage)message).getFacesMessage();
        }
        FacesMessage.Severity severity = SPRING_SEVERITY_TO_FACES.get(message.getSeverity());
        if (severity == null) {
            severity = FacesMessage.SEVERITY_INFO;
        }
        return new FacesMessage(severity, message.getText(), null);
    }

    void setViewRootRestoredFromFlashScope() {
        this.viewRootHolderFromFlashScope = true;
    }

    public boolean isPostback() {
        return this.viewRootHolderFromFlashScope || super.isPostback();
    }

    public static FlowFacesContext newInstance(RequestContext context, Lifecycle lifecycle) {
        FacesContext defaultFacesContext = FlowFacesContext.newDefaultInstance(context, lifecycle);
        return new FlowFacesContext(context, defaultFacesContext);
    }

    private static FacesContext newDefaultInstance(RequestContext context, Lifecycle lifecycle) {
        Object nativeContext = context.getExternalContext().getNativeContext();
        Object nativeRequest = context.getExternalContext().getNativeRequest();
        Object nativeResponse = context.getExternalContext().getNativeResponse();
        return FacesContextHelper.newDefaultInstance(nativeContext, nativeRequest, nativeResponse, lifecycle);
    }

    static {
        SPRING_SEVERITY_TO_FACES.put(Severity.INFO, FacesMessage.SEVERITY_INFO);
        SPRING_SEVERITY_TO_FACES.put(Severity.WARNING, FacesMessage.SEVERITY_WARN);
        SPRING_SEVERITY_TO_FACES.put(Severity.ERROR, FacesMessage.SEVERITY_ERROR);
        SPRING_SEVERITY_TO_FACES.put(Severity.FATAL, FacesMessage.SEVERITY_FATAL);
        FACES_SEVERITY_TO_SPRING = new HashMap<FacesMessage.Severity, Severity>();
        for (Map.Entry<Severity, FacesMessage.Severity> entry : SPRING_SEVERITY_TO_FACES.entrySet()) {
            FACES_SEVERITY_TO_SPRING.put(entry.getValue(), entry.getKey());
        }
    }

    public static class FacesMessageSource
    implements Serializable {
        private String clientId;

        public FacesMessageSource(String clientId) {
            if (StringUtils.hasLength((String)clientId)) {
                this.clientId = clientId;
            }
        }

        public String getClientId() {
            return this.clientId;
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode((Object)this.clientId);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass().equals(FacesMessageSource.class)) {
                return ObjectUtils.nullSafeEquals((Object)this.getClientId(), (Object)((FacesMessageSource)obj).getClientId());
            }
            return false;
        }
    }

    protected static class FlowFacesMessage
    extends Message
    implements MessageResolver {
        private transient FacesMessage facesMessage;

        public FlowFacesMessage(FacesMessageSource source, FacesMessage message) {
            super((Object)source, null, null);
            this.facesMessage = this.asStandardFacesMessageInstance(message);
        }

        private FacesMessage asStandardFacesMessageInstance(FacesMessage message) {
            if (FacesMessage.class.equals(message.getClass())) {
                return message;
            }
            return new FacesMessage(message.getSeverity(), message.getSummary(), message.getDetail());
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
            oos.writeObject(this.facesMessage.getSummary());
            oos.writeObject(this.facesMessage.getDetail());
            oos.writeInt(this.facesMessage.getSeverity().getOrdinal());
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            String summary = (String)ois.readObject();
            String detail = (String)ois.readObject();
            int severityOrdinal = ois.readInt();
            FacesMessage.Severity severity = FacesMessage.SEVERITY_INFO;
            for (FacesMessage.Severity value : FacesMessage.VALUES) {
                if (value.getOrdinal() != severityOrdinal) continue;
                severity = value;
            }
            this.facesMessage = new FacesMessage(severity, summary, detail);
        }

        public String getText() {
            StringBuilder text = new StringBuilder();
            if (StringUtils.hasLength((String)this.facesMessage.getSummary())) {
                text.append(this.facesMessage.getSummary());
            }
            if (StringUtils.hasLength((String)this.facesMessage.getDetail())) {
                text.append(text.length() == 0 ? "" : " : ");
                text.append(this.facesMessage.getDetail());
            }
            return text.toString();
        }

        public Severity getSeverity() {
            Severity severity = null;
            if (this.facesMessage.getSeverity() != null) {
                severity = (Severity)FACES_SEVERITY_TO_SPRING.get(this.facesMessage.getSeverity());
            }
            return severity == null ? Severity.INFO : severity;
        }

        public String toString() {
            ToStringCreator rtn = new ToStringCreator((Object)this);
            rtn.append("severity", (Object)this.getSeverity());
            if (FacesContext.getCurrentInstance() != null) {
                rtn.append("text", (Object)this.getText());
            }
            return rtn.toString();
        }

        public Message resolveMessage(MessageSource messageSource, Locale locale) {
            return this;
        }

        public FacesMessage getFacesMessage() {
            return this.facesMessage;
        }
    }
}

