/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.webflow.execution.RequestContext;

public class JsfRuntimeInformation {
    private static final ClassLoader CLASSLOADER = JsfRuntimeInformation.class.getClassLoader();
    public static final int JSF_22 = 4;
    public static final int JSF_21 = 3;
    public static final int JSF_20 = 2;
    @Deprecated
    public static final int JSF_12 = 1;
    @Deprecated
    public static final int JSF_11 = 0;
    private static final int jsfVersion = ReflectionUtils.findMethod(FacesContext.class, (String)"getResourceLibraryContracts") != null ? 4 : (ReflectionUtils.findMethod(FacesContext.class, (String)"isReleased") != null ? 3 : (ReflectionUtils.findMethod(FacesContext.class, (String)"isPostback") != null ? 2 : (ReflectionUtils.findMethod(FacesContext.class, (String)"getELContext") != null ? 1 : 0)));
    private static final boolean mojarraPresent = ClassUtils.isPresent((String)"com.sun.faces.context.FacesContextImpl", (ClassLoader)CLASSLOADER);
    private static final boolean myFacesPresent = ClassUtils.isPresent((String)"org.apache.myfaces.webapp.MyFacesServlet", (ClassLoader)CLASSLOADER);
    private static Boolean myFacesInUse;
    private static boolean portletPresent;
    private static boolean springPortletPresent;

    public static boolean isAtLeastJsf22() {
        return jsfVersion >= 4;
    }

    public static boolean isAtLeastJsf21() {
        return jsfVersion >= 3;
    }

    public static boolean isAtLeastJsf20() {
        return jsfVersion >= 2;
    }

    @Deprecated
    public static boolean isAtLeastJsf12() {
        return jsfVersion >= 1;
    }

    @Deprecated
    public static boolean isLessThanJsf20() {
        return jsfVersion < 2;
    }

    public static boolean isMojarraPresent() {
        return mojarraPresent;
    }

    public static boolean isMyFacesPresent() {
        return myFacesPresent;
    }

    public static boolean isMyFacesInUse() {
        if (myFacesInUse == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return false;
            }
            while (facesContext instanceof FacesContextWrapper) {
                facesContext = ((FacesContextWrapper)facesContext).getWrapped();
            }
            myFacesInUse = facesContext.getClass().getPackage().getName().startsWith("org.apache.myfaces.");
        }
        return myFacesInUse;
    }

    public static boolean isSpringPortletPresent() {
        return portletPresent && springPortletPresent;
    }

    public static boolean isPortletRequest(FacesContext context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        return JsfRuntimeInformation.isPortletContext(context.getExternalContext().getContext());
    }

    public static boolean isPortletRequest(RequestContext context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        return JsfRuntimeInformation.isPortletContext(context.getExternalContext().getNativeContext());
    }

    public static boolean isPortletContext(Object nativeContext) {
        Assert.notNull((Object)nativeContext, (String)"Context must not be null");
        return ClassUtils.getMethodIfAvailable(nativeContext.getClass(), (String)"getPortletContextName", (Class[])new Class[0]) != null;
    }

    static {
        portletPresent = ClassUtils.isPresent((String)"javax.portlet.Portlet", (ClassLoader)CLASSLOADER);
        springPortletPresent = ClassUtils.isPresent((String)"org.springframework.web.portlet.DispatcherPortlet", (ClassLoader)CLASSLOADER);
    }
}

