/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.support;

import org.springframework.binding.convert.ConversionExecutionException;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.support.FluentParserContext;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.WildcardTransitionCriteria;
import org.springframework.webflow.engine.builder.FlowBuilderContext;
import org.springframework.webflow.engine.support.DefaultTransitionCriteria;
import org.springframework.webflow.execution.RequestContext;

class TextToTransitionCriteria
implements Converter {
    private FlowBuilderContext flowBuilderContext;

    public TextToTransitionCriteria(FlowBuilderContext flowBuilderContext) {
        this.flowBuilderContext = flowBuilderContext;
    }

    public Class<?> getSourceClass() {
        return String.class;
    }

    public Class<?> getTargetClass() {
        return TransitionCriteria.class;
    }

    public Object convertSourceToTargetClass(Object source, Class<?> targetClass) throws Exception {
        String encodedCriteria = (String)source;
        ExpressionParser parser = this.flowBuilderContext.getExpressionParser();
        if (!StringUtils.hasText((String)encodedCriteria) || "*".equals(encodedCriteria)) {
            return WildcardTransitionCriteria.INSTANCE;
        }
        return this.createBooleanExpressionTransitionCriteria(encodedCriteria, parser);
    }

    protected TransitionCriteria createBooleanExpressionTransitionCriteria(String encodedCriteria, ExpressionParser parser) throws ConversionExecutionException {
        Expression expression = parser.parseExpression(encodedCriteria, (ParserContext)new FluentParserContext().template().evaluate(RequestContext.class));
        return new DefaultTransitionCriteria(expression);
    }
}

