/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.factory;

import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteria;

public class FlowExecutionListenerCriteriaFactory {
    private static final WildcardFlowExecutionListenerCriteria WILDCARD_INSTANCE = new WildcardFlowExecutionListenerCriteria();

    public FlowExecutionListenerCriteria getListenerCriteria(String encodedCriteria) {
        if ("*".equals(encodedCriteria)) {
            return this.allFlows();
        }
        String[] flowIds = StringUtils.commaDelimitedListToStringArray((String)encodedCriteria);
        for (int i = 0; i < flowIds.length; ++i) {
            flowIds[i] = flowIds[i].trim();
        }
        return this.flows(flowIds);
    }

    public FlowExecutionListenerCriteria allFlows() {
        return WILDCARD_INSTANCE;
    }

    public FlowExecutionListenerCriteria flow(String flowId) {
        return new FlowIdFlowExecutionListenerCriteria(flowId);
    }

    public FlowExecutionListenerCriteria flows(String ... flowIds) {
        return new FlowIdFlowExecutionListenerCriteria(flowIds);
    }

    private static class FlowIdFlowExecutionListenerCriteria
    implements FlowExecutionListenerCriteria {
        private String[] flowIds;

        public FlowIdFlowExecutionListenerCriteria(String ... flowIds) {
            Assert.notEmpty((Object[])flowIds, (String)"The flow id array is required");
            this.flowIds = flowIds;
        }

        @Override
        public boolean appliesTo(FlowDefinition definition) {
            for (String flowId : this.flowIds) {
                if (!flowId.equals(definition.getId())) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("flowIds", (Object)StylerUtils.style((Object)this.flowIds)).toString();
        }
    }

    private static class WildcardFlowExecutionListenerCriteria
    implements FlowExecutionListenerCriteria {
        private WildcardFlowExecutionListenerCriteria() {
        }

        @Override
        public boolean appliesTo(FlowDefinition definition) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }
}

