/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.jaxb;

import java.io.IOException;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.springframework.core.io.Resource;
import org.springframework.oxm.jaxb.AbstractJaxbMarshaller;
import org.springframework.oxm.jaxb.JaxbUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.xml.transform.StaxResult;
import org.springframework.xml.transform.StaxSource;
import org.springframework.xml.validation.SchemaLoaderUtils;
import org.xml.sax.SAXException;

public class Jaxb2Marshaller
extends AbstractJaxbMarshaller {
    private Resource[] schemaResources;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Marshaller.Listener marshallerListener;
    private Unmarshaller.Listener unmarshallerListener;
    private XmlAdapter[] adapters;
    private Schema schema;
    private Class[] classesToBeBound;
    private Map jaxbContextProperties;

    public void setAdapters(XmlAdapter[] adapters) {
        this.adapters = adapters;
    }

    public void setClassesToBeBound(Class[] classesToBeBound) {
        this.classesToBeBound = classesToBeBound;
    }

    public void setJaxbContextProperties(Map jaxbContextProperties) {
        this.jaxbContextProperties = jaxbContextProperties;
    }

    public void setMarshallerListener(Marshaller.Listener marshallerListener) {
        this.marshallerListener = marshallerListener;
    }

    public void setSchema(Resource schemaResource) {
        this.schemaResources = new Resource[]{schemaResource};
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public void setSchemas(Resource[] schemaResources) {
        this.schemaResources = schemaResources;
    }

    public void setUnmarshallerListener(Unmarshaller.Listener unmarshallerListener) {
        this.unmarshallerListener = unmarshallerListener;
    }

    public void marshal(Object graph, Result result) {
        try {
            if (result instanceof StaxResult) {
                this.marshalStaxResult(graph, (StaxResult)result);
            } else {
                this.createMarshaller().marshal(graph, result);
            }
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    public Object unmarshal(Source source) {
        try {
            if (source instanceof StaxSource) {
                return this.unmarshalStaxSource((StaxSource)source);
            }
            return this.createUnmarshaller().unmarshal(source);
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    protected void initJaxbMarshaller(Marshaller marshaller) throws JAXBException {
        if (this.schema != null) {
            marshaller.setSchema(this.schema);
        }
        if (this.marshallerListener != null) {
            marshaller.setListener(this.marshallerListener);
        }
        if (this.adapters != null) {
            for (int i = 0; i < this.adapters.length; ++i) {
                marshaller.setAdapter(this.adapters[i]);
            }
        }
    }

    protected void initJaxbUnmarshaller(Unmarshaller unmarshaller) throws JAXBException {
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
        if (this.unmarshallerListener != null) {
            unmarshaller.setListener(this.unmarshallerListener);
        }
        if (this.adapters != null) {
            for (int i = 0; i < this.adapters.length; ++i) {
                unmarshaller.setAdapter(this.adapters[i]);
            }
        }
    }

    protected JAXBContext createJaxbContext() throws Exception {
        if (JaxbUtils.getJaxbVersion() < 1) {
            throw new IllegalStateException("Cannot use Jaxb2Marshaller in combination with JAXB 1.0. Use Jaxb1Marshaller instead.");
        }
        if (StringUtils.hasLength((String)this.getContextPath()) && !ObjectUtils.isEmpty((Object[])this.classesToBeBound)) {
            throw new IllegalArgumentException("specify either contextPath or classesToBeBound property; not both");
        }
        this.loadSchema();
        if (StringUtils.hasLength((String)this.getContextPath())) {
            return this.createJaxbContextFromContextPath();
        }
        if (!ObjectUtils.isEmpty((Object[])this.classesToBeBound)) {
            return this.createJaxbContextFromClasses();
        }
        throw new IllegalArgumentException("setting either contextPath or classesToBeBound is required");
    }

    private JAXBContext createJaxbContextFromContextPath() throws JAXBException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Creating JAXBContext with context path [" + this.getContextPath() + "]"));
        }
        if (this.jaxbContextProperties != null) {
            return JAXBContext.newInstance((String)this.getContextPath(), (ClassLoader)ClassUtils.getDefaultClassLoader(), (Map)this.jaxbContextProperties);
        }
        return JAXBContext.newInstance((String)this.getContextPath());
    }

    private JAXBContext createJaxbContextFromClasses() throws JAXBException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Creating JAXBContext with classes to be bound [" + StringUtils.arrayToCommaDelimitedString((Object[])this.classesToBeBound) + "]"));
        }
        if (this.jaxbContextProperties != null) {
            return JAXBContext.newInstance((Class[])this.classesToBeBound, (Map)this.jaxbContextProperties);
        }
        return JAXBContext.newInstance((Class[])this.classesToBeBound);
    }

    private void loadSchema() throws IOException, SAXException {
        if (!ObjectUtils.isEmpty((Object[])this.schemaResources)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting validation schema to " + StringUtils.arrayToCommaDelimitedString((Object[])this.schemaResources)));
            }
            this.schema = SchemaLoaderUtils.loadSchema((Resource[])this.schemaResources, (String)this.schemaLanguage);
        }
    }

    private void marshalStaxResult(Object graph, StaxResult staxResult) throws JAXBException {
        if (staxResult.getXMLStreamWriter() != null) {
            this.createMarshaller().marshal(graph, staxResult.getXMLStreamWriter());
        } else if (staxResult.getXMLEventWriter() != null) {
            this.createMarshaller().marshal(graph, staxResult.getXMLEventWriter());
        } else {
            throw new IllegalArgumentException("StaxResult contains neither XMLStreamWriter nor XMLEventConsumer");
        }
    }

    private Object unmarshalStaxSource(StaxSource staxSource) throws JAXBException {
        if (staxSource.getXMLStreamReader() != null) {
            return this.createUnmarshaller().unmarshal(staxSource.getXMLStreamReader());
        }
        if (staxSource.getXMLEventReader() != null) {
            return this.createUnmarshaller().unmarshal(staxSource.getXMLEventReader());
        }
        throw new IllegalArgumentException("StaxSource contains neither XMLStreamReader nor XMLEventReader");
    }
}

