/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSProcessor;
import com.sun.xml.wss.XWSSProcessorFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.WssSoapFaultException;
import java.io.IOException;
import java.io.InputStream;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.soap.SOAPMessage;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.saaj.SaajSoapMessage;
import org.springframework.ws.soap.security.AbstractWsSecurityInterceptor;
import org.springframework.ws.soap.security.WsSecurityValidationException;
import org.springframework.ws.soap.security.callback.CleanupCallback;
import org.springframework.ws.soap.security.xwss.XwsSecurityFaultException;
import org.springframework.ws.soap.security.xwss.XwsSecuritySecurementException;
import org.springframework.ws.soap.security.xwss.XwsSecurityValidationException;
import org.springframework.ws.soap.security.xwss.callback.XwssCallbackHandlerChain;

public class XwsSecurityInterceptor
extends AbstractWsSecurityInterceptor
implements InitializingBean {
    private XWSSProcessor processor;
    private CallbackHandler callbackHandler;
    private Resource policyConfiguration;

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void setCallbackHandlers(CallbackHandler[] callbackHandler) {
        this.callbackHandler = new XwssCallbackHandlerChain(callbackHandler);
    }

    public void setPolicyConfiguration(Resource policyConfiguration) {
        this.policyConfiguration = policyConfiguration;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.policyConfiguration, (String)"policyConfiguration is required");
        Assert.isTrue((boolean)this.policyConfiguration.exists(), (String)("policyConfiguration [" + this.policyConfiguration + "] does not exist"));
        Assert.notNull((Object)this.callbackHandler, (String)"callbackHandler is required");
        XWSSProcessorFactory processorFactory = XWSSProcessorFactory.newInstance();
        InputStream is = null;
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Loading policy configuration from from '" + this.policyConfiguration + "'"));
            }
            is = this.policyConfiguration.getInputStream();
            this.processor = processorFactory.createProcessorForSecurityConfiguration(is, this.callbackHandler);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    protected void secureMessage(SoapMessage soapMessage, MessageContext messageContext) throws XwsSecuritySecurementException {
        Assert.isTrue((boolean)(soapMessage instanceof SaajSoapMessage), (String)"XwsSecurityInterceptor requires a SaajSoapMessage. Use a SaajSoapMessageFactory to create the SOAP messages.");
        SaajSoapMessage saajSoapMessage = (SaajSoapMessage)soapMessage;
        try {
            ProcessingContext context = this.processor.createProcessingContext(saajSoapMessage.getSaajMessage());
            SOAPMessage result = this.processor.secureOutboundMessage(context);
            saajSoapMessage.setSaajMessage(result);
        }
        catch (XWSSecurityException ex) {
            throw new XwsSecuritySecurementException(ex.getMessage(), ex);
        }
        catch (WssSoapFaultException ex) {
            throw new XwsSecurityFaultException(ex.getFaultCode(), ex.getFaultString(), ex.getFaultActor());
        }
    }

    @Override
    protected void validateMessage(SoapMessage soapMessage, MessageContext messageContext) throws WsSecurityValidationException {
        Assert.isTrue((boolean)(soapMessage instanceof SaajSoapMessage), (String)"XwsSecurityInterceptor requires a SaajSoapMessage. Use a SaajSoapMessageFactory to create the SOAP messages.");
        SaajSoapMessage saajSoapMessage = (SaajSoapMessage)soapMessage;
        try {
            ProcessingContext context = this.processor.createProcessingContext(saajSoapMessage.getSaajMessage());
            SOAPMessage result = this.processor.verifyInboundMessage(context);
            saajSoapMessage.setSaajMessage(result);
        }
        catch (XWSSecurityException ex) {
            throw new XwsSecurityValidationException(ex.getMessage(), ex);
        }
        catch (WssSoapFaultException ex) {
            throw new XwsSecurityFaultException(ex.getFaultCode(), ex.getFaultString(), ex.getFaultActor());
        }
    }

    @Override
    protected void cleanUp() {
        if (this.callbackHandler != null) {
            try {
                CleanupCallback cleanupCallback = new CleanupCallback();
                this.callbackHandler.handle(new Callback[]{cleanupCallback});
            }
            catch (IOException ex) {
                this.logger.warn((Object)"Cleanup callback resulted in IOException", (Throwable)ex);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                // empty catch block
            }
        }
    }
}

