/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.wss4j2.callback;

import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ws.soap.security.support.KeyStoreUtils;
import org.springframework.ws.soap.security.wss4j2.callback.AbstractWsPasswordCallbackHandler;

public class KeyStoreCallbackHandler
extends AbstractWsPasswordCallbackHandler
implements InitializingBean {
    private String privateKeyPassword;
    private char[] symmetricKeyPassword;
    private KeyStore keyStore;

    @Override
    protected void handleDecrypt(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        callback.setPassword(this.privateKeyPassword);
    }

    @Override
    protected void handleSecretKey(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        Key key;
        String id = callback.getIdentifier();
        try {
            key = this.keyStore.getKey(id, this.symmetricKeyPassword != null ? this.symmetricKeyPassword : this.privateKeyPassword.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new IOException("Could not get key", ex);
        }
        callback.setKey(key.getEncoded());
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        if (privateKeyPassword != null) {
            this.privateKeyPassword = privateKeyPassword;
        }
    }

    public void setSymmetricKeyPassword(String symmetricKeyPassword) {
        if (symmetricKeyPassword != null) {
            this.symmetricKeyPassword = symmetricKeyPassword.toCharArray();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.keyStore == null) {
            this.loadDefaultKeyStore();
        }
        if (this.symmetricKeyPassword == null) {
            this.symmetricKeyPassword = this.privateKeyPassword.toCharArray();
        }
    }

    protected void loadDefaultKeyStore() {
        try {
            this.keyStore = KeyStoreUtils.loadDefaultKeyStore();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Loaded default key store");
            }
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Could not open default key store", (Throwable)ex);
        }
    }
}

