/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.x509.cache;

import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.x509.cache.X509UserCache;

public class SpringBasedX509UserCache
implements X509UserCache,
InitializingBean {
    private static final Log logger = LogFactory.getLog(SpringBasedX509UserCache.class);
    private Cache cache;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"cache is mandatory");
    }

    @Override
    public @Nullable UserDetails getUserFromCache(X509Certificate userCert) {
        if (logger.isDebugEnabled()) {
            String subjectDN = "unknown";
            if (userCert.getSubjectX500Principal() != null) {
                subjectDN = userCert.getSubjectX500Principal().toString();
            }
            logger.debug((Object)("X.509 Cache hit. SubjectDN: " + subjectDN));
        }
        return (UserDetails)this.cache.get((Object)userCert, UserDetails.class);
    }

    @Override
    public void putUserInCache(X509Certificate userCert, UserDetails user) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + String.valueOf(userCert.getSubjectX500Principal())));
        }
        this.cache.put((Object)userCert, (Object)user);
    }

    @Override
    public void removeUserFromCache(X509Certificate userCert) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache remove: " + String.valueOf(userCert.getSubjectX500Principal())));
        }
        this.cache.evict((Object)userCert);
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

