/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.FaultAwareWebServiceMessage;
import org.springframework.ws.NoEndpointFoundException;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointAdapter;
import org.springframework.ws.server.EndpointExceptionResolver;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointInvocationChain;
import org.springframework.ws.server.EndpointMapping;
import org.springframework.ws.support.DefaultStrategiesHelper;
import org.springframework.ws.transport.WebServiceMessageReceiver;

public class MessageDispatcher
implements WebServiceMessageReceiver,
BeanNameAware,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String ENDPOINT_NOT_FOUND_LOG_CATEGORY = "org.springframework.ws.server.EndpointNotFound";
    protected static final Log endpointNotFoundLogger = LogFactory.getLog((String)"org.springframework.ws.server.EndpointNotFound");
    public static final String MESSAGE_TRACING_LOG_CATEGORY = "org.springframework.ws.server.MessageTracing";
    protected static final Log sentMessageTracingLogger = LogFactory.getLog((String)"org.springframework.ws.server.MessageTracing.sent");
    protected static final Log receivedMessageTracingLogger = LogFactory.getLog((String)"org.springframework.ws.server.MessageTracing.received");
    private final DefaultStrategiesHelper defaultStrategiesHelper;
    private String beanName;
    private List endpointAdapters;
    private List endpointExceptionResolvers;
    private List endpointMappings;

    public MessageDispatcher() {
        ClassPathResource resource = new ClassPathResource(ClassUtils.getShortName(this.getClass()) + ".properties", this.getClass());
        this.defaultStrategiesHelper = new DefaultStrategiesHelper((Resource)resource);
    }

    public List getEndpointAdapters() {
        return this.endpointAdapters;
    }

    public void setEndpointAdapters(List endpointAdapters) {
        this.endpointAdapters = endpointAdapters;
    }

    public List getEndpointExceptionResolvers() {
        return this.endpointExceptionResolvers;
    }

    public void setEndpointExceptionResolvers(List endpointExceptionResolvers) {
        this.endpointExceptionResolvers = endpointExceptionResolvers;
    }

    public List getEndpointMappings() {
        return this.endpointMappings;
    }

    public void setEndpointMappings(List endpointMappings) {
        this.endpointMappings = endpointMappings;
    }

    public final void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.initEndpointAdapters(applicationContext);
        this.initEndpointExceptionResolvers(applicationContext);
        this.initEndpointMappings(applicationContext);
    }

    public void receive(MessageContext messageContext) throws Exception {
        if (receivedMessageTracingLogger.isTraceEnabled()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            messageContext.getRequest().writeTo(os);
            receivedMessageTracingLogger.trace((Object)("Received request [" + os.toString("UTF-8") + "]"));
        } else if (receivedMessageTracingLogger.isDebugEnabled()) {
            receivedMessageTracingLogger.debug((Object)("Received request [" + messageContext.getRequest() + "]"));
        }
        this.dispatch(messageContext);
        if (messageContext.hasResponse()) {
            if (sentMessageTracingLogger.isTraceEnabled()) {
                ByteArrayOutputStream requestStream = new ByteArrayOutputStream();
                messageContext.getRequest().writeTo(requestStream);
                ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
                messageContext.getResponse().writeTo(responseStream);
                sentMessageTracingLogger.trace((Object)("Sent response [" + responseStream.toString("UTF-8") + "] for request [" + requestStream.toString("UTF-8") + "]"));
            } else if (sentMessageTracingLogger.isDebugEnabled()) {
                sentMessageTracingLogger.debug((Object)("Sent response [" + messageContext.getResponse() + "] for request [" + messageContext.getRequest() + "]"));
            }
        } else if (sentMessageTracingLogger.isDebugEnabled()) {
            sentMessageTracingLogger.debug((Object)("MessageDispatcher with name '" + this.beanName + "' sends no response for request [" + messageContext.getRequest() + "]"));
        }
    }

    protected final void dispatch(MessageContext messageContext) throws Exception {
        EndpointInvocationChain mappedEndpoint = null;
        int interceptorIndex = -1;
        try {
            mappedEndpoint = this.getEndpoint(messageContext);
            if (mappedEndpoint == null || mappedEndpoint.getEndpoint() == null) {
                throw new NoEndpointFoundException(messageContext.getRequest());
            }
            if (!this.handleRequest(mappedEndpoint, messageContext)) {
                return;
            }
            if (mappedEndpoint.getInterceptors() != null) {
                int i = 0;
                while (i < mappedEndpoint.getInterceptors().length) {
                    EndpointInterceptor interceptor = mappedEndpoint.getInterceptors()[i];
                    interceptorIndex = i++;
                    if (interceptor.handleRequest(messageContext, mappedEndpoint.getEndpoint())) continue;
                    this.triggerHandleResponse(mappedEndpoint, interceptorIndex, messageContext);
                    return;
                }
            }
            EndpointAdapter endpointAdapter = this.getEndpointAdapter(mappedEndpoint.getEndpoint());
            endpointAdapter.invoke(messageContext, mappedEndpoint.getEndpoint());
            this.triggerHandleResponse(mappedEndpoint, interceptorIndex, messageContext);
        }
        catch (NoEndpointFoundException ex) {
            if (endpointNotFoundLogger.isWarnEnabled()) {
                endpointNotFoundLogger.warn((Object)("No endpoint mapping found for [" + messageContext.getRequest() + "]"));
            }
            throw ex;
        }
        catch (Exception ex) {
            Object endpoint = mappedEndpoint != null ? mappedEndpoint.getEndpoint() : null;
            this.processEndpointException(messageContext, endpoint, ex);
            this.triggerHandleResponse(mappedEndpoint, interceptorIndex, messageContext);
        }
    }

    protected EndpointInvocationChain getEndpoint(MessageContext messageContext) throws Exception {
        Iterator iterator = this.endpointMappings.iterator();
        while (iterator.hasNext()) {
            EndpointMapping endpointMapping = (EndpointMapping)iterator.next();
            EndpointInvocationChain endpoint = endpointMapping.getEndpoint(messageContext);
            if (endpoint != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Endpoint mapping [" + endpointMapping + "] maps request to endpoint [" + endpoint.getEndpoint() + "]"));
                }
                return endpoint;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Endpoint mapping [" + endpointMapping + "] has no mapping for request"));
        }
        return null;
    }

    protected EndpointAdapter getEndpointAdapter(Object endpoint) {
        Iterator iterator = this.endpointAdapters.iterator();
        while (iterator.hasNext()) {
            EndpointAdapter endpointAdapter = (EndpointAdapter)iterator.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing endpoint adapter [" + endpointAdapter + "]"));
            }
            if (!endpointAdapter.supports(endpoint)) continue;
            return endpointAdapter;
        }
        throw new IllegalStateException("No adapter for endpoint [" + endpoint + "]: Does your endpoint implement a " + "supported interface like MessageHandler or PayloadEndpoint?");
    }

    protected boolean handleRequest(EndpointInvocationChain mappedEndpoint, MessageContext messageContext) {
        return true;
    }

    protected void processEndpointException(MessageContext messageContext, Object endpoint, Exception ex) throws Exception {
        Iterator iterator = this.endpointExceptionResolvers.iterator();
        while (iterator.hasNext()) {
            EndpointExceptionResolver resolver = (EndpointExceptionResolver)iterator.next();
            if (!resolver.resolveException(messageContext, endpoint, ex)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Endpoint invocation resulted in exception - responding with Fault", (Throwable)ex);
            }
            return;
        }
        throw ex;
    }

    private void triggerHandleResponse(EndpointInvocationChain mappedEndpoint, int interceptorIndex, MessageContext messageContext) throws Exception {
        if (mappedEndpoint != null && messageContext.hasResponse() && !ObjectUtils.isEmpty((Object[])mappedEndpoint.getInterceptors())) {
            boolean hasFault = false;
            WebServiceMessage response = messageContext.getResponse();
            if (response instanceof FaultAwareWebServiceMessage) {
                hasFault = ((FaultAwareWebServiceMessage)response).hasFault();
            }
            boolean resume = true;
            for (int i = interceptorIndex; resume && i >= 0; --i) {
                EndpointInterceptor interceptor = mappedEndpoint.getInterceptors()[i];
                resume = !hasFault ? interceptor.handleResponse(messageContext, mappedEndpoint.getEndpoint()) : interceptor.handleFault(messageContext, mappedEndpoint.getEndpoint());
            }
        }
    }

    private void initEndpointAdapters(ApplicationContext applicationContext) throws BeansException {
        if (this.endpointAdapters == null) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, (Class)EndpointAdapter.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.endpointAdapters = new ArrayList(matchingBeans.values());
                Collections.sort(this.endpointAdapters, new OrderComparator());
            } else {
                this.endpointAdapters = this.defaultStrategiesHelper.getDefaultStrategies(EndpointAdapter.class, applicationContext);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"No EndpointAdapters found, using defaults");
                }
            }
        }
    }

    private void initEndpointExceptionResolvers(ApplicationContext applicationContext) throws BeansException {
        if (this.endpointExceptionResolvers == null) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, (Class)EndpointExceptionResolver.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.endpointExceptionResolvers = new ArrayList(matchingBeans.values());
                Collections.sort(this.endpointExceptionResolvers, new OrderComparator());
            } else {
                this.endpointExceptionResolvers = this.defaultStrategiesHelper.getDefaultStrategies(EndpointExceptionResolver.class, applicationContext);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"No EndpointExceptionResolvers found, using defaults");
                }
            }
        }
    }

    private void initEndpointMappings(ApplicationContext applicationContext) throws BeansException {
        if (this.endpointMappings == null) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, (Class)EndpointMapping.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.endpointMappings = new ArrayList(matchingBeans.values());
                Collections.sort(this.endpointMappings, new OrderComparator());
            } else {
                this.endpointMappings = this.defaultStrategiesHelper.getDefaultStrategies(EndpointMapping.class, applicationContext);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"No EndpointMappings found, using defaults");
                }
            }
        }
    }
}

