/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.mail;

import java.util.Properties;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.Assert;
import org.springframework.ws.transport.mail.MailReceiverConnection;
import org.springframework.ws.transport.mail.monitor.MonitoringStrategy;
import org.springframework.ws.transport.mail.monitor.PollingMonitoringStrategy;
import org.springframework.ws.transport.mail.monitor.Pop3PollingMonitoringStrategy;
import org.springframework.ws.transport.mail.support.MailTransportUtils;
import org.springframework.ws.transport.support.AbstractAsyncStandaloneMessageReceiver;

public class MailMessageReceiver
extends AbstractAsyncStandaloneMessageReceiver {
    private Session session = Session.getInstance((Properties)new Properties(), null);
    private URLName storeUri;
    private URLName transportUri;
    private Folder folder;
    private Store store;
    private InternetAddress from;
    private MonitoringStrategy monitoringStrategy;

    public void setFrom(String from) throws AddressException {
        this.from = new InternetAddress(from);
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.session = Session.getInstance((Properties)javaMailProperties, null);
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public void setStoreUri(String storeUri) {
        this.storeUri = new URLName(storeUri);
    }

    public void setTransportUri(String transportUri) {
        this.transportUri = new URLName(transportUri);
    }

    public void setMonitoringStrategy(MonitoringStrategy monitoringStrategy) {
        this.monitoringStrategy = monitoringStrategy;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.storeUri, (String)"Property 'storeUri' is required");
        Assert.notNull((Object)this.transportUri, (String)"Property 'transportUri' is required");
        if (this.monitoringStrategy == null) {
            String protocol = this.storeUri.getProtocol();
            if ("pop3".equals(protocol)) {
                this.monitoringStrategy = new Pop3PollingMonitoringStrategy();
            } else if ("imap".equals(protocol)) {
                this.monitoringStrategy = new PollingMonitoringStrategy();
            } else {
                throw new IllegalArgumentException("Cannot determine monitoring strategy for \"" + protocol + "\". " + "Set the 'monitoringStrategy' explicitly.");
            }
        }
        super.afterPropertiesSet();
    }

    protected void onActivate() throws MessagingException {
        this.openSession();
        this.openFolder();
    }

    protected void onStart() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Starting mail receiver [" + MailTransportUtils.toPasswordProtectedString(this.storeUri) + "]"));
        }
        this.execute((Runnable)((Object)new MonitoringRunnable()));
    }

    protected void onStop() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopping mail receiver [" + MailTransportUtils.toPasswordProtectedString(this.storeUri) + "]"));
        }
        this.closeFolder();
    }

    protected void onShutdown() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Shutting down mail receiver [" + MailTransportUtils.toPasswordProtectedString(this.storeUri) + "]"));
        }
        this.closeFolder();
        this.closeSession();
    }

    private void openSession() throws MessagingException {
        this.store = this.session.getStore(this.storeUri);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connecting to store [" + MailTransportUtils.toPasswordProtectedString(this.storeUri) + "]"));
        }
        this.store.connect();
    }

    private void openFolder() throws MessagingException {
        if (this.folder != null && this.folder.isOpen()) {
            return;
        }
        this.folder = this.store.getFolder(this.storeUri);
        if (this.folder == null || !this.folder.exists()) {
            throw new IllegalStateException("No default folder to receive from");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Opening folder [" + MailTransportUtils.toPasswordProtectedString(this.storeUri) + "]"));
        }
        this.folder.open(this.monitoringStrategy.getFolderOpenMode());
    }

    private void closeFolder() {
        MailTransportUtils.closeFolder(this.folder, true);
    }

    private void closeSession() {
        MailTransportUtils.closeService((Service)this.store);
    }

    private class MessageHandler
    implements SchedulingAwareRunnable {
        private final Message message;

        public MessageHandler(Message message) {
            this.message = message;
        }

        public void run() {
            MailReceiverConnection connection = new MailReceiverConnection(this.message, MailMessageReceiver.this.session);
            connection.setTransportUri(MailMessageReceiver.this.transportUri);
            connection.setFrom(MailMessageReceiver.this.from);
            try {
                MailMessageReceiver.this.handleConnection(connection);
            }
            catch (Exception ex) {
                MailMessageReceiver.this.logger.error((Object)"Could not handle incoming mail connection", (Throwable)ex);
            }
        }

        public boolean isLongLived() {
            return false;
        }
    }

    private class MonitoringRunnable
    implements SchedulingAwareRunnable {
        private MonitoringRunnable() {
        }

        public void run() {
            try {
                MailMessageReceiver.this.openFolder();
                while (MailMessageReceiver.this.isRunning()) {
                    try {
                        Message[] messages = MailMessageReceiver.this.monitoringStrategy.monitor(MailMessageReceiver.this.folder);
                        for (int i = 0; i < messages.length; ++i) {
                            MessageHandler handler = new MessageHandler(messages[i]);
                            MailMessageReceiver.this.execute((Runnable)((Object)handler));
                        }
                    }
                    catch (FolderClosedException ex) {
                        MailMessageReceiver.this.logger.debug((Object)"Folder closed, reopening");
                        if (!MailMessageReceiver.this.isRunning()) continue;
                        MailMessageReceiver.this.openFolder();
                    }
                    catch (MessagingException ex) {
                        MailMessageReceiver.this.logger.warn((Object)ex);
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (MessagingException ex) {
                MailMessageReceiver.this.logger.error((Object)ex);
            }
        }

        public boolean isLongLived() {
            return true;
        }
    }
}

