/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.transform;

import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransformerFactoryUtils {
    private static final Log log = LogFactory.getLog(TransformerFactoryUtils.class);

    public static TransformerFactory newInstance() {
        return TransformerFactoryUtils.defaultSettings(TransformerFactory.newInstance());
    }

    public static TransformerFactory newInstance(Class<? extends TransformerFactory> transformerFactoryClass) {
        try {
            return TransformerFactoryUtils.defaultSettings(transformerFactoryClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new TransformerFactoryConfigurationError(e, "Could not instantiate TransformerFactory [" + transformerFactoryClass + "]");
        }
        catch (IllegalAccessException e) {
            throw new TransformerFactoryConfigurationError(e, "Could not instantiate TransformerFactory [" + transformerFactoryClass + "]");
        }
    }

    private static TransformerFactory defaultSettings(TransformerFactory factory) {
        block5: {
            block4: {
                try {
                    factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                }
                catch (IllegalArgumentException e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("http://javax.xml.XMLConstants/property/accessExternalDTD property not supported by " + factory.getClass().getCanonicalName()));
                }
            }
            try {
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            }
            catch (IllegalArgumentException e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn((Object)("http://javax.xml.XMLConstants/property/accessExternalStylesheet property not supported by " + factory.getClass().getCanonicalName()));
            }
        }
        return factory;
    }
}

