/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.validation;

import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SchemaFactoryUtils {
    private static final Log log = LogFactory.getLog(SchemaFactoryUtils.class);

    public static SchemaFactory newInstance(String schemaLanguage) {
        SchemaFactory schemaFactory;
        block9: {
            block8: {
                schemaFactory = SchemaFactory.newInstance(schemaLanguage);
                try {
                    schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                }
                catch (SAXNotRecognizedException e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("http://javax.xml.XMLConstants/property/accessExternalDTD property not supported by " + schemaFactory.getClass().getCanonicalName()));
                    }
                }
                catch (SAXNotSupportedException e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn((Object)("http://javax.xml.XMLConstants/property/accessExternalDTD property not supported by " + schemaFactory.getClass().getCanonicalName()));
                }
            }
            try {
                schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "file,jar:file");
            }
            catch (SAXNotRecognizedException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("http://javax.xml.XMLConstants/property/accessExternalSchema property not supported by " + schemaFactory.getClass().getCanonicalName()));
                }
            }
            catch (SAXNotSupportedException e) {
                if (!log.isWarnEnabled()) break block9;
                log.warn((Object)("http://javax.xml.XMLConstants/property/accessExternalSchema property not supported by " + schemaFactory.getClass().getCanonicalName()));
            }
        }
        return schemaFactory;
    }
}

