/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.rest.domain;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;
import org.springframework.xd.rest.domain.ModuleMetadataResource;

@XmlRootElement
public class DetailedContainerResource
extends ResourceSupport {
    private String containerId;
    private String groups;
    private int deploymentSize;
    private List<ModuleMetadataResource> deployedModules;
    private Map<String, HashMap<String, Double>> messageRates;
    private Map<String, String> attributes;

    private DetailedContainerResource() {
    }

    public DetailedContainerResource(Map<String, String> attributes, int deploymentSize, List<ModuleMetadataResource> deployedModules, Map<String, HashMap<String, Double>> messageRates) {
        Assert.notNull(attributes);
        this.containerId = attributes.get("id");
        this.groups = attributes.get("groups");
        this.attributes = attributes;
        this.deploymentSize = deploymentSize;
        this.deployedModules = deployedModules;
        this.messageRates = messageRates;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getGroups() {
        return this.groups;
    }

    public int getDeploymentSize() {
        return this.deploymentSize;
    }

    public List<ModuleMetadataResource> getDeployedModules() {
        return this.deployedModules;
    }

    public Map<String, HashMap<String, Double>> getMessageRates() {
        return this.messageRates;
    }

    public String toString() {
        return this.attributes.toString();
    }

    public static class Page
    extends PagedResources<DetailedContainerResource> {
    }
}

