/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.rest.domain.support;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.springframework.hateoas.PagedResources;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.AbstractJaxb2HttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.xd.rest.domain.DetailedContainerResource;
import org.springframework.xd.rest.domain.JobDefinitionResource;
import org.springframework.xd.rest.domain.ModuleDefinitionResource;
import org.springframework.xd.rest.domain.ModuleMetadataResource;
import org.springframework.xd.rest.domain.StreamDefinitionResource;
import org.springframework.xd.rest.domain.XDRuntime;
import org.springframework.xd.rest.domain.metrics.AggregateCountsResource;
import org.springframework.xd.rest.domain.metrics.CounterResource;
import org.springframework.xd.rest.domain.metrics.FieldValueCounterResource;
import org.springframework.xd.rest.domain.metrics.GaugeResource;
import org.springframework.xd.rest.domain.metrics.MetricResource;
import org.springframework.xd.rest.domain.metrics.RichGaugeResource;

public class RestTemplateMessageConverterUtil {
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)RestTemplateMessageConverterUtil.class.getClassLoader());
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)RestTemplateMessageConverterUtil.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)RestTemplateMessageConverterUtil.class.getClassLoader());
    private static final boolean jacksonPresent = ClassUtils.isPresent((String)"org.codehaus.jackson.map.ObjectMapper", (ClassLoader)RestTemplateMessageConverterUtil.class.getClassLoader()) && ClassUtils.isPresent((String)"org.codehaus.jackson.JsonGenerator", (ClassLoader)RestTemplateMessageConverterUtil.class.getClassLoader());
    private static final Class<?>[] ourClasses = new Class[]{PagedResources.class, StreamDefinitionResource.class, JobDefinitionResource.class, ModuleDefinitionResource.class, DetailedContainerResource.class, ModuleMetadataResource.class, MetricResource.class, GaugeResource.class, AggregateCountsResource.class, CounterResource.class, XDRuntime.class, FieldValueCounterResource.class, RichGaugeResource.class};

    private RestTemplateMessageConverterUtil() {
    }

    public static List<HttpMessageConverter<?>> installMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        messageConverters.add((HttpMessageConverter<?>)new AllEncompassingFormHttpMessageConverter());
        if (jackson2Present) {
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        } else if (jacksonPresent) {
            messageConverters.add((HttpMessageConverter<?>)new MappingJacksonHttpMessageConverter());
        }
        if (jaxb2Present) {
            Jaxb2RootElementHttpMessageConverter jaxbConverter = new Jaxb2RootElementHttpMessageConverter();
            RestTemplateMessageConverterUtil.initializeJAXBContexts(jaxbConverter);
            messageConverters.add((HttpMessageConverter<?>)jaxbConverter);
        }
        return messageConverters;
    }

    private static void initializeJAXBContexts(AbstractJaxb2HttpMessageConverter<?> c) {
        Field f = ReflectionUtils.findField(AbstractJaxb2HttpMessageConverter.class, (String)"jaxbContexts");
        ReflectionUtils.makeAccessible((Field)f);
        Map contexts = (Map)ReflectionUtils.getField((Field)f, c);
        try {
            for (Class<?> clazz : ourClasses) {
                JAXBContext context = JAXBContext.newInstance((Class[])ourClasses);
                contexts.put(clazz, context);
            }
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }
}

