/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.flush;

import java.lang.reflect.Method;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.metadata.Attributes;
import org.springframework.util.StringUtils;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.interceptor.flush.AbstractFlushingInterceptor;
import org.springmodules.cache.interceptor.flush.FlushCache;
import org.springmodules.cache.interceptor.flush.FlushingAttributeSource;
import org.springmodules.cache.interceptor.flush.MetadataFlushingAttributeSource;

public class MetadataFlushingInterceptor
extends AbstractFlushingInterceptor {
    private FlushingAttributeSource flushingAttributeSource;

    public final FlushingAttributeSource getFlushingAttributeSource() {
        return this.flushingAttributeSource;
    }

    public final void setAttributes(Attributes attributes) {
        MetadataFlushingAttributeSource source = new MetadataFlushingAttributeSource();
        source.setAttributes(attributes);
        this.setFlushingAttributeSource(source);
    }

    public final void setFlushingAttributeSource(FlushingAttributeSource newFlushingAttributeSource) {
        this.flushingAttributeSource = newFlushingAttributeSource;
    }

    protected FlushCache getFlushingAttribute(MethodInvocation methodInvocation) {
        Object thisObject = methodInvocation.getThis();
        Class<?> targetClass = thisObject != null ? thisObject.getClass() : null;
        Method method = methodInvocation.getMethod();
        FlushingAttributeSource attributeSource = this.getFlushingAttributeSource();
        FlushCache attribute = attributeSource.attribute(method, targetClass);
        return attribute;
    }

    protected final FlushingModel getModel(MethodInvocation methodInvocation) {
        String id;
        FlushCache attribute;
        Map flushingModels = this.getFlushingModels();
        FlushingModel model = null;
        if (flushingModels != null && !flushingModels.isEmpty() && (attribute = this.getFlushingAttribute(methodInvocation)) != null && StringUtils.hasText((String)(id = attribute.getModelId()))) {
            model = (FlushingModel)flushingModels.get(id);
        }
        return model;
    }
}

