/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.util;

import java.util.HashSet;
import java.util.Set;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class Objects {
    private static final String ARRAY_ELEMENT_SEPARATOR = ", ";
    private static final String ARRAY_END = "}";
    private static final String ARRAY_START = "{";
    private static final String EMPTY_ARRAY = "{}";
    private static final int INITIAL_HASH = 7;
    private static final int MULTIPLIER = 31;
    private static final String NULL_ARRAY = "null";
    private static final Set primitivesAndWrappers = new HashSet();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public static int hashCode(boolean bool) {
        return bool ? 1231 : 1237;
    }

    public static int hashCode(double dbl) {
        long bits = Double.doubleToLongBits(dbl);
        return Objects.hashCode(bits);
    }

    public static int hashCode(float flt) {
        return Float.floatToIntBits(flt);
    }

    public static int hashCode(long lng) {
        return (int)(lng ^ lng >>> 32);
    }

    public static StringBuffer identityToString(Object obj) {
        StringBuffer buffer = new StringBuffer();
        if (obj != null) {
            buffer.append(obj.getClass().getName());
            buffer.append("@");
            buffer.append(ObjectUtils.getIdentityHexString((Object)obj));
        }
        return buffer;
    }

    public static boolean isArrayOfPrimitives(Object array) {
        boolean primitiveArray = false;
        if (array != null) {
            Class<?> clazz = array.getClass();
            primitiveArray = clazz.isArray() && clazz.getComponentType().isPrimitive();
        }
        return primitiveArray;
    }

    public static boolean isPrimitiveOrWrapper(Class clazz) {
        return primitivesAndWrappers.contains(clazz);
    }

    public static int nullSafeHashCode(boolean[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + Objects.hashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(byte[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static int nullSafeHashCode(char[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static int nullSafeHashCode(double[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + Objects.hashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(float[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + Objects.hashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(int[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static int nullSafeHashCode(long[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + Objects.hashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof boolean[]) {
            return Objects.nullSafeHashCode((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Objects.nullSafeHashCode((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Objects.nullSafeHashCode((char[])obj);
        }
        if (obj instanceof double[]) {
            return Objects.nullSafeHashCode((double[])obj);
        }
        if (obj instanceof float[]) {
            return Objects.nullSafeHashCode((float[])obj);
        }
        if (obj instanceof int[]) {
            return Objects.nullSafeHashCode((int[])obj);
        }
        if (obj instanceof long[]) {
            return Objects.nullSafeHashCode((long[])obj);
        }
        if (obj instanceof short[]) {
            return Objects.nullSafeHashCode((short[])obj);
        }
        if (obj instanceof Object[]) {
            return Objects.nullSafeHashCode((Object[])obj);
        }
        return obj.hashCode();
    }

    public static int nullSafeHashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + Objects.nullSafeHashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(short[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static String nullSafeToString(boolean[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(byte[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(char[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append("'" + array[i] + "'");
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(double[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(float[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(int[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(long[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(Object[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(StringUtils.quoteIfString((Object)array[i]));
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(short[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(String[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(StringUtils.quote((String)array[i]));
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitivesAndWrappers.add(Boolean.TYPE);
        primitivesAndWrappers.add(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Objects.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        primitivesAndWrappers.add(Byte.TYPE);
        primitivesAndWrappers.add(class$java$lang$Byte == null ? (class$java$lang$Byte = Objects.class$("java.lang.Byte")) : class$java$lang$Byte);
        primitivesAndWrappers.add(Character.TYPE);
        primitivesAndWrappers.add(class$java$lang$Character == null ? (class$java$lang$Character = Objects.class$("java.lang.Character")) : class$java$lang$Character);
        primitivesAndWrappers.add(Double.TYPE);
        primitivesAndWrappers.add(class$java$lang$Double == null ? (class$java$lang$Double = Objects.class$("java.lang.Double")) : class$java$lang$Double);
        primitivesAndWrappers.add(Float.TYPE);
        primitivesAndWrappers.add(class$java$lang$Float == null ? (class$java$lang$Float = Objects.class$("java.lang.Float")) : class$java$lang$Float);
        primitivesAndWrappers.add(Integer.TYPE);
        primitivesAndWrappers.add(class$java$lang$Integer == null ? (class$java$lang$Integer = Objects.class$("java.lang.Integer")) : class$java$lang$Integer);
        primitivesAndWrappers.add(Long.TYPE);
        primitivesAndWrappers.add(class$java$lang$Long == null ? (class$java$lang$Long = Objects.class$("java.lang.Long")) : class$java$lang$Long);
        primitivesAndWrappers.add(Short.TYPE);
        primitivesAndWrappers.add(class$java$lang$Short == null ? (class$java$lang$Short = Objects.class$("java.lang.Short")) : class$java$lang$Short);
    }
}

