/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.config.tangosol;

import org.springframework.util.StringUtils;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.config.AbstractCacheModelParser;
import org.springmodules.cache.provider.tangosol.CoherenceCachingModel;
import org.springmodules.cache.provider.tangosol.CoherenceFlushingModel;
import org.w3c.dom.Element;

public final class CoherenceModelParser
extends AbstractCacheModelParser {
    public CachingModel parseCachingModel(Element element) {
        String cacheName = element.getAttribute("cacheName");
        CoherenceCachingModel model = new CoherenceCachingModel(cacheName);
        String timeToLiveAttr = element.getAttribute("timeToLive");
        if (StringUtils.hasText((String)timeToLiveAttr)) {
            try {
                long timeToLive = Long.parseLong(timeToLiveAttr);
                model.setTimeToLive(timeToLive);
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        return model;
    }

    protected FlushingModel doParseFlushingModel(Element element, boolean flushBeforeMethodExecution) {
        String csvCacheNames = element.getAttribute("cacheNames");
        CoherenceFlushingModel model = new CoherenceFlushingModel(csvCacheNames);
        model.setFlushBeforeMethodExecution(flushBeforeMethodExecution);
        return model;
    }
}

