/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.oscache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.HashMap;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.util.ObjectUtils;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FatalCacheException;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.provider.AbstractCacheProviderFacade;
import org.springmodules.cache.provider.CacheModelValidator;
import org.springmodules.cache.provider.ReflectionCacheModelEditor;
import org.springmodules.cache.provider.oscache.OsCacheCachingModel;
import org.springmodules.cache.provider.oscache.OsCacheFlushingModel;
import org.springmodules.cache.provider.oscache.OsCacheModelValidator;
import org.springmodules.cache.provider.oscache.RefreshPeriodEditor;

public final class OsCacheFacade
extends AbstractCacheProviderFacade {
    private GeneralCacheAdministrator cacheManager;
    private CacheModelValidator cacheModelValidator = new OsCacheModelValidator();
    static /* synthetic */ Class class$org$springmodules$cache$provider$oscache$OsCacheCachingModel;
    static /* synthetic */ Class class$org$springmodules$cache$provider$oscache$OsCacheFlushingModel;

    public CacheModelValidator modelValidator() {
        return this.cacheModelValidator;
    }

    public PropertyEditor getCachingModelEditor() {
        HashMap<String, RefreshPeriodEditor> propertyEditors = new HashMap<String, RefreshPeriodEditor>();
        propertyEditors.put("refreshPeriod", new RefreshPeriodEditor());
        ReflectionCacheModelEditor editor = new ReflectionCacheModelEditor();
        editor.setCacheModelClass(class$org$springmodules$cache$provider$oscache$OsCacheCachingModel == null ? (class$org$springmodules$cache$provider$oscache$OsCacheCachingModel = OsCacheFacade.class$("org.springmodules.cache.provider.oscache.OsCacheCachingModel")) : class$org$springmodules$cache$provider$oscache$OsCacheCachingModel);
        editor.setCacheModelPropertyEditors(propertyEditors);
        return editor;
    }

    public PropertyEditor getFlushingModelEditor() {
        HashMap<String, StringArrayPropertyEditor> propertyEditors = new HashMap<String, StringArrayPropertyEditor>();
        propertyEditors.put("cacheNames", new StringArrayPropertyEditor());
        ReflectionCacheModelEditor editor = new ReflectionCacheModelEditor();
        editor.setCacheModelClass(class$org$springmodules$cache$provider$oscache$OsCacheFlushingModel == null ? (class$org$springmodules$cache$provider$oscache$OsCacheFlushingModel = OsCacheFacade.class$("org.springmodules.cache.provider.oscache.OsCacheFlushingModel")) : class$org$springmodules$cache$provider$oscache$OsCacheFlushingModel);
        editor.setCacheModelPropertyEditors(propertyEditors);
        return editor;
    }

    public void setCacheManager(GeneralCacheAdministrator newCacheManager) {
        this.cacheManager = newCacheManager;
    }

    protected String getEntryKey(Serializable key) {
        return key.toString();
    }

    protected boolean isSerializableCacheElementRequired() {
        return false;
    }

    protected void onCancelCacheUpdate(Serializable key) {
        String newKey = this.getEntryKey(key);
        this.cacheManager.cancelUpdate(newKey);
    }

    protected void onFlushCache(FlushingModel model) {
        OsCacheFlushingModel cachingModel = (OsCacheFlushingModel)model;
        Object[] groups = cachingModel.getGroups();
        if (!ObjectUtils.isEmpty((Object[])groups)) {
            int groupCount = groups.length;
            for (int i = 0; i < groupCount; ++i) {
                Object group = groups[i];
                this.cacheManager.flushGroup((String)group);
            }
        } else {
            this.cacheManager.flushAll();
        }
    }

    protected Object onGetFromCache(Serializable key, CachingModel model) {
        OsCacheCachingModel cachingModel = (OsCacheCachingModel)model;
        Integer refreshPeriod = cachingModel.getRefreshPeriod();
        String cronExpression = cachingModel.getCronExpression();
        String newKey = this.getEntryKey(key);
        Object cachedObject = null;
        try {
            cachedObject = null == refreshPeriod ? this.cacheManager.getFromCache(newKey) : (null == cronExpression ? this.cacheManager.getFromCache(newKey, refreshPeriod.intValue()) : this.cacheManager.getFromCache(newKey, refreshPeriod.intValue(), cronExpression));
        }
        catch (NeedsRefreshException needsRefreshException) {
            this.cacheManager.cancelUpdate(newKey);
        }
        return cachedObject;
    }

    protected void onPutInCache(Serializable key, CachingModel model, Object obj) {
        OsCacheCachingModel cachingModel = (OsCacheCachingModel)model;
        String newKey = this.getEntryKey(key);
        String[] groups = cachingModel.getGroups();
        if (groups == null || groups.length == 0) {
            this.cacheManager.putInCache(newKey, obj);
        } else {
            this.cacheManager.putInCache(newKey, obj, groups);
        }
    }

    protected void onRemoveFromCache(Serializable key, CachingModel model) {
        String newKey = this.getEntryKey(key);
        this.cacheManager.flushEntry(newKey);
    }

    protected void validateCacheManager() throws FatalCacheException {
        this.assertCacheManagerIsNotNull(this.cacheManager);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

