/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.commons.configuration;

import java.net.URL;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class CommonsConfigurationFactoryBean
implements InitializingBean,
FactoryBean {
    private CompositeConfiguration configuration;
    private Configuration[] configurations;
    private Resource[] locations;
    private boolean throwExceptionOnMissing = true;
    static /* synthetic */ Class class$java$util$Properties;

    public CommonsConfigurationFactoryBean() {
    }

    public CommonsConfigurationFactoryBean(Configuration configuration) {
        Assert.notNull((Object)configuration);
        this.configuration = new CompositeConfiguration(configuration);
    }

    public Object getObject() throws Exception {
        return this.configuration != null ? ConfigurationConverter.getProperties((Configuration)this.configuration) : null;
    }

    public Class getObjectType() {
        return class$java$util$Properties == null ? (class$java$util$Properties = CommonsConfigurationFactoryBean.class$("java.util.Properties")) : class$java$util$Properties;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        int i;
        if (!(this.configuration != null || this.configurations != null && this.configurations.length != 0 || this.locations != null && this.locations.length != 0)) {
            throw new IllegalArgumentException("no configuration object or location specified");
        }
        if (this.configuration == null) {
            this.configuration = new CompositeConfiguration();
        }
        this.configuration.setThrowExceptionOnMissing(this.throwExceptionOnMissing);
        if (this.configurations != null) {
            for (i = 0; i < this.configurations.length; ++i) {
                this.configuration.addConfiguration(this.configurations[i]);
            }
        }
        if (this.locations != null) {
            for (i = 0; i < this.locations.length; ++i) {
                URL url = this.locations[i].getURL();
                PropertiesConfiguration props = new PropertiesConfiguration(url);
                this.configuration.addConfiguration((Configuration)props);
            }
        }
    }

    public Configuration[] getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Configuration[] configurations) {
        this.configurations = configurations;
    }

    public Resource[] getLocations() {
        return this.locations;
    }

    public void setLocations(Resource[] locations) {
        this.locations = locations;
    }

    public boolean isThrowExceptionOnMissing() {
        return this.throwExceptionOnMissing;
    }

    public void setThrowExceptionOnMissing(boolean throwExceptionOnMissing) {
        this.throwExceptionOnMissing = throwExceptionOnMissing;
    }

    public CompositeConfiguration getConfiguration() {
        return this.configuration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

