/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.workflow.jbpm31;

import java.sql.SQLException;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springmodules.workflow.jbpm31.JbpmAccessor;
import org.springmodules.workflow.jbpm31.JbpmCallback;
import org.springmodules.workflow.jbpm31.JbpmOperations;
import org.springmodules.workflow.jbpm31.JbpmUtils;

public class JbpmTemplate
extends JbpmAccessor
implements JbpmOperations {
    private ProcessDefinition processDefinition;
    private HibernateTemplate hibernateTemplate;
    private boolean hasPersistenceService;
    private String contextName = "default.jbpm.context";

    public Object execute(final JbpmCallback callback) {
        final JbpmContext context = this.getContext();
        try {
            if (this.hibernateTemplate != null && this.hasPersistenceService) {
                Object object = this.hibernateTemplate.execute(new HibernateCallback(){

                    public Object doInHibernate(Session session) throws HibernateException, SQLException {
                        context.setSession(session);
                        return callback.doInJbpm(context);
                    }
                });
                return object;
            }
            Object object = callback.doInJbpm(context);
            return object;
        }
        catch (JbpmException ex) {
            throw JbpmTemplate.convertJbpmException(ex);
        }
        finally {
            this.releaseContext(context);
        }
    }

    protected void releaseContext(JbpmContext jbpmContext) {
        jbpmContext.close();
    }

    protected JbpmContext getContext() {
        JbpmContext context = this.jbpmConfiguration.createJbpmContext(this.contextName);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        JbpmContext dummy = this.getContext();
        try {
            if (JbpmUtils.hasPersistenceService(dummy)) {
                this.hasPersistenceService = true;
                this.logger.debug((Object)"jBPM persistence service present");
            }
            if (this.hibernateTemplate != null) {
                this.logger.debug((Object)"hibernateTemplate present - jBPM persistence service will be managed by Spring");
            } else if (dummy.getSessionFactory() != null) {
                this.logger.debug((Object)"creating hibernateTemplate based on jBPM SessionFactory");
                this.hibernateTemplate = new HibernateTemplate(dummy.getSessionFactory());
            } else {
                this.logger.debug((Object)"hibernateTemplate missing - jBPM will handle its own persistence");
            }
        }
        finally {
            dummy.close();
        }
    }

    public JbpmTemplate() {
    }

    public JbpmTemplate(JbpmConfiguration jbpmConfiguration) {
        this.jbpmConfiguration = jbpmConfiguration;
    }

    public JbpmTemplate(JbpmConfiguration jbpmConfiguration, ProcessDefinition processDefinition) {
        this.jbpmConfiguration = jbpmConfiguration;
        this.processDefinition = processDefinition;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    public ProcessInstance findProcessInstance(final Long processInstanceId) {
        return (ProcessInstance)this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                return context.getGraphSession().loadProcessInstance(processInstanceId.longValue());
            }
        });
    }

    public List findProcessInstances() {
        return (List)this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                return context.getGraphSession().findProcessInstances(JbpmTemplate.this.processDefinition.getId());
            }
        });
    }

    public List findPooledTaskInstances(final String actorId) {
        return (List)this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                return context.getTaskMgmtSession().findPooledTaskInstances(actorId);
            }
        });
    }

    public List findPooledTaskInstances(final List actorIds) {
        return (List)this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                return context.getTaskMgmtSession().findPooledTaskInstances(actorIds);
            }
        });
    }

    public List findTaskInstances(final String actorId) {
        return (List)this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                return context.getTaskMgmtSession().findTaskInstances(actorId);
            }
        });
    }

    public List findTaskInstances(final String[] actorIds) {
        return (List)this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                return context.getTaskMgmtSession().findTaskInstances(actorIds);
            }
        });
    }

    public List findTaskInstances(final List actorIds) {
        return (List)this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                return context.getTaskMgmtSession().findTaskInstances(actorIds);
            }
        });
    }

    public List findTaskInstancesByToken(Token token) {
        return this.findTaskInstancesByToken(token.getId());
    }

    public List findTaskInstancesByToken(final long tokenId) {
        return (List)this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                return context.getTaskMgmtSession().findTaskInstancesByToken(tokenId);
            }
        });
    }

    public void signal(final ProcessInstance processInstance) {
        this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                processInstance.signal();
                return null;
            }
        });
    }

    public Long saveProcessInstance(final ProcessInstance processInstance) {
        return (Long)this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                context.save(processInstance);
                return new Long(processInstance.getId());
            }
        });
    }

    public void signal(final ProcessInstance processInstance, final String transitionId) {
        this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                processInstance.signal(transitionId);
                return null;
            }
        });
    }

    public void signal(final ProcessInstance processInstance, final Transition transition) {
        this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                processInstance.signal(transition);
                return null;
            }
        });
        throw new UnsupportedOperationException();
    }

    public void signalToken(final ProcessInstance processInstance, final String tokenName) {
        this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                Token token = processInstance.getRootToken().findToken(tokenName);
                if (token == null) {
                    processInstance.signal();
                } else {
                    token.signal();
                }
                return null;
            }
        });
    }

    public void signalToken(final ProcessInstance processInstance, final String tokenName, final String transitionId) {
        this.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                Token token = processInstance.getRootToken().findToken(tokenName);
                if (token == null) {
                    processInstance.signal(transitionId);
                } else {
                    token.signal(transitionId);
                }
                return null;
            }
        });
    }
}

