/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.workflow.jbpm31;

import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.graph.def.ProcessDefinition;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springmodules.workflow.jbpm31.JbpmFactoryLocator;
import org.springmodules.workflow.jbpm31.JbpmUtils;
import org.springmodules.workflow.jbpm31.definition.ProcessDefinitionFactoryBean;

public class LocalJbpmConfigurationFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean,
BeanFactoryAware,
BeanNameAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springmodules$workflow$jbpm31$LocalJbpmConfigurationFactoryBean == null ? (class$org$springmodules$workflow$jbpm31$LocalJbpmConfigurationFactoryBean = LocalJbpmConfigurationFactoryBean.class$("org.springmodules.workflow.jbpm31.LocalJbpmConfigurationFactoryBean")) : class$org$springmodules$workflow$jbpm31$LocalJbpmConfigurationFactoryBean));
    private JbpmConfiguration jbpmConfiguration;
    private ObjectFactory objectFactory;
    private Resource configuration;
    private boolean createSchema;
    private boolean dropSchema;
    private boolean hasPersistenceService;
    private String contextName = "default.jbpm.context";
    private Resource[] processDefinitionsResources;
    private ProcessDefinition[] processDefinitions;
    private SessionFactory sessionFactory;
    private JbpmFactoryLocator factoryLocator = new JbpmFactoryLocator();
    static /* synthetic */ Class class$org$springmodules$workflow$jbpm31$LocalJbpmConfigurationFactoryBean;
    static /* synthetic */ Class class$org$jbpm$JbpmConfiguration;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.factoryLocator.setBeanFactory(beanFactory);
    }

    public void setBeanName(String name) {
        this.factoryLocator.setBeanName(name);
    }

    public void destroy() throws Exception {
        if (this.dropSchema && this.hasPersistenceService) {
            logger.info((Object)"dropping schema");
            this.jbpmConfiguration.dropSchema(this.contextName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterPropertiesSet() throws Exception {
        JbpmContext context;
        ObjectFactory jbpmObjectFactory;
        if (this.configuration == null && this.objectFactory == null) {
            throw new IllegalArgumentException("configuration or objectFactory property need to be not null");
        }
        if (this.configuration != null) {
            logger.info((Object)("creating JbpmConfiguration from resource " + this.configuration.getDescription()));
            InputStream stream = this.configuration.getInputStream();
            jbpmObjectFactory = ObjectFactoryParser.parseInputStream((InputStream)stream);
            stream.close();
        } else {
            jbpmObjectFactory = this.objectFactory;
        }
        this.jbpmConfiguration = new JbpmConfiguration(jbpmObjectFactory);
        if (this.sessionFactory != null) {
            logger.info((Object)"using given Hibernate session factory");
            context = this.jbpmConfiguration.createJbpmContext(this.contextName);
            try {
                context.setSessionFactory(this.sessionFactory);
            }
            finally {
                context.close();
            }
        }
        this.hasPersistenceService = JbpmUtils.hasPersistenceService(this.jbpmConfiguration, this.contextName);
        if (this.hasPersistenceService) {
            logger.info((Object)"persistence service available...");
            if (this.createSchema) {
                logger.info((Object)"creating schema");
                this.jbpmConfiguration.createSchema(this.contextName);
            }
            if (this.processDefinitions == null && this.processDefinitionsResources == null) return;
            context = this.jbpmConfiguration.createJbpmContext(this.contextName);
            try {
                if (this.processDefinitions != null) {
                    String toString = Arrays.asList(this.processDefinitions).toString();
                    logger.info((Object)("deploying process definitions:" + toString));
                    for (int i = 0; i < this.processDefinitions.length; ++i) {
                        context.deployProcessDefinition(this.processDefinitions[i]);
                    }
                }
                if (this.processDefinitionsResources == null) return;
                ProcessDefinitionFactoryBean factory = new ProcessDefinitionFactoryBean();
                String toString = Arrays.asList(this.processDefinitionsResources).toString();
                logger.info((Object)("deploying process definitions (from resources):" + toString));
                for (int i = 0; i < this.processDefinitionsResources.length; ++i) {
                    factory.setDefinitionLocation(this.processDefinitionsResources[i]);
                    factory.afterPropertiesSet();
                    context.deployProcessDefinition((ProcessDefinition)factory.getObject());
                }
                return;
            }
            finally {
                context.close();
            }
        } else {
            logger.info((Object)"persistence unavailable not available - schema create/drop and process definition deployment disabled");
        }
    }

    public Object getObject() throws Exception {
        return this.jbpmConfiguration;
    }

    public Class getObjectType() {
        return class$org$jbpm$JbpmConfiguration == null ? (class$org$jbpm$JbpmConfiguration = LocalJbpmConfigurationFactoryBean.class$("org.jbpm.JbpmConfiguration")) : class$org$jbpm$JbpmConfiguration;
    }

    public boolean isSingleton() {
        return true;
    }

    public Resource getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Resource configuration) {
        this.configuration = configuration;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public boolean isCreateSchema() {
        return this.createSchema;
    }

    public void setCreateSchema(boolean createSchema) {
        this.createSchema = createSchema;
    }

    public boolean isDropSchema() {
        return this.dropSchema;
    }

    public void setDropSchema(boolean dropSchema) {
        this.dropSchema = dropSchema;
    }

    public ProcessDefinition[] getProcessDefinitions() {
        return this.processDefinitions;
    }

    public void setProcessDefinitions(ProcessDefinition[] processDefinitions) {
        this.processDefinitions = processDefinitions;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Resource[] getProcessDefinitionsResources() {
        return this.processDefinitionsResources;
    }

    public void setProcessDefinitionsResources(Resource[] processDefinitionsResources) {
        this.processDefinitionsResources = processDefinitionsResources;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

