/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jcr;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.ObservationManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springmodules.jcr.EventListenerDefinition;
import org.springmodules.jcr.JcrUtils;
import org.springmodules.jcr.SessionFactory;
import org.springmodules.jcr.SessionHolder;
import org.springmodules.jcr.SessionHolderProvider;
import org.springmodules.jcr.SessionHolderProviderManager;
import org.springmodules.jcr.support.GenericSessionHolderProvider;

public class JcrSessionFactory
implements InitializingBean,
DisposableBean,
SessionFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$springmodules$jcr$JcrSessionFactory == null ? (class$org$springmodules$jcr$JcrSessionFactory = JcrSessionFactory.class$("org.springmodules.jcr.JcrSessionFactory")) : class$org$springmodules$jcr$JcrSessionFactory));
    private Repository repository;
    private String workspaceName;
    private Credentials credentials;
    private EventListenerDefinition[] eventListeners = new EventListenerDefinition[0];
    private Properties namespaces;
    private Map overwrittenNamespaces;
    private boolean forceNamespacesRegistration = false;
    private boolean keepNewNamespaces = true;
    private boolean skipExistingNamespaces = true;
    private SessionHolderProviderManager sessionHolderProviderManager;
    private SessionHolderProvider sessionHolderProvider;
    static /* synthetic */ Class class$org$springmodules$jcr$JcrSessionFactory;

    public JcrSessionFactory(Repository repository, String workspaceName, Credentials credentials) {
        this(repository, workspaceName, credentials, null);
    }

    public JcrSessionFactory(Repository repository, String workspaceName, Credentials credentials, SessionHolderProviderManager sessionHolderProviderManager) {
        this.repository = repository;
        this.workspaceName = workspaceName;
        this.credentials = credentials;
        this.sessionHolderProviderManager = sessionHolderProviderManager;
    }

    public JcrSessionFactory() {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getRepository(), (String)"repository is required");
        if (this.eventListeners != null && this.eventListeners.length > 0 && !JcrUtils.supportsObservation(this.getRepository())) {
            throw new IllegalArgumentException("repository " + this.getRepositoryInfo() + " does NOT support Observation; remove Listener definitions");
        }
        this.registerNodeTypes();
        this.registerNamespaces();
        if (this.sessionHolderProviderManager == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"no session holder provider manager set; using the default one");
            }
            this.sessionHolderProvider = new GenericSessionHolderProvider();
        } else {
            this.sessionHolderProvider = this.sessionHolderProviderManager.getSessionProvider(this.getRepository());
        }
    }

    protected void registerNodeTypes() throws Exception {
    }

    protected void unregisterNodeTypes() throws Exception {
    }

    protected void registerNamespaces() throws Exception {
        Iterator<Object> iter;
        if (this.namespaces == null || this.namespaces.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("registering custom namespaces " + this.namespaces));
        }
        NamespaceRegistry registry = this.getSession().getWorkspace().getNamespaceRegistry();
        Object[] prefixes = registry.getPrefixes();
        Arrays.sort(prefixes);
        if (this.forceNamespacesRegistration) {
            if (!this.keepNewNamespaces) {
                this.overwrittenNamespaces = new HashMap(this.namespaces.size());
            }
            iter = this.namespaces.keySet().iterator();
            while (iter.hasNext()) {
                String prefix = (String)iter.next();
                int position = Arrays.binarySearch(prefixes, prefix);
                if (position < 0) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("prefix " + prefix + " was already registered; unregistering it"));
                }
                if (!this.keepNewNamespaces) {
                    this.overwrittenNamespaces.put(prefix, registry.getURI(prefix));
                }
                registry.unregisterNamespace(prefix);
            }
        }
        iter = this.namespaces.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry namespace = (Map.Entry)iter.next();
            String prefix = (String)namespace.getKey();
            String ns = (String)namespace.getValue();
            int position = Arrays.binarySearch(prefixes, prefix);
            if (this.skipExistingNamespaces && position >= 0) {
                log.debug((Object)("namespace already registered under [" + prefix + "]; skipping registration"));
                continue;
            }
            log.debug((Object)("registering namespace [" + ns + "] under [" + prefix + "]"));
            registry.registerNamespace(prefix, ns);
        }
    }

    public void destroy() throws Exception {
        this.unregisterNamespaces();
        this.unregisterNodeTypes();
    }

    protected void unregisterNamespaces() throws Exception {
        if (this.namespaces == null || this.namespaces.isEmpty() || this.keepNewNamespaces) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("unregistering custom namespaces " + this.namespaces));
        }
        NamespaceRegistry registry = this.getSession().getWorkspace().getNamespaceRegistry();
        Iterator<Object> iter = this.namespaces.keySet().iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            registry.unregisterNamespace(prefix);
        }
        if (this.forceNamespacesRegistration) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("reverting back overwritten namespaces " + this.overwrittenNamespaces));
            }
            if (this.overwrittenNamespaces != null) {
                iter = this.overwrittenNamespaces.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    registry.registerNamespace((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    public Session getSession() throws RepositoryException {
        return this.addListeners(this.repository.login(this.credentials, this.workspaceName));
    }

    public SessionHolder getSessionHolder(Session session) {
        return this.sessionHolderProvider.createSessionHolder(session);
    }

    protected Session addListeners(Session session) throws RepositoryException {
        if (this.eventListeners != null && this.eventListeners.length > 0) {
            Workspace ws = session.getWorkspace();
            ObservationManager manager = ws.getObservationManager();
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding listeners " + Arrays.asList(this.eventListeners).toString() + " for session " + session));
            }
            for (int i = 0; i < this.eventListeners.length; ++i) {
                manager.addEventListener(this.eventListeners[i].getListener(), this.eventListeners[i].getEventTypes(), this.eventListeners[i].getAbsPath(), this.eventListeners[i].isDeep(), this.eventListeners[i].getUuid(), this.eventListeners[i].getNodeTypeName(), this.eventListeners[i].isNoLocal());
            }
        }
        return session;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JcrSessionFactory) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.repository.hashCode();
        if (this.credentials != null) {
            result = 37 * result + this.credentials.hashCode();
        }
        if (this.workspaceName != null) {
            result = 37 * result + this.workspaceName.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SessionFactory for ");
        buffer.append(this.getRepositoryInfo());
        buffer.append("|workspace=");
        buffer.append(this.workspaceName);
        return buffer.toString();
    }

    public EventListenerDefinition[] getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(EventListenerDefinition[] eventListenerDefinitions) {
        this.eventListeners = eventListenerDefinitions;
    }

    private String getRepositoryInfo() {
        if (this.getRepository() == null) {
            return "<N/A>";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getRepository().getDescriptor("jcr.repository.name"));
        buffer.append(" ");
        buffer.append(this.getRepository().getDescriptor("jcr.repository.version"));
        return buffer.toString();
    }

    public Properties getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Properties namespaces) {
        this.namespaces = namespaces;
    }

    protected SessionHolderProvider getSessionHolderProvider() {
        return this.sessionHolderProvider;
    }

    protected void setSessionHolderProvider(SessionHolderProvider sessionHolderProvider) {
        this.sessionHolderProvider = sessionHolderProvider;
    }

    public SessionHolderProviderManager getSessionHolderProviderManager() {
        return this.sessionHolderProviderManager;
    }

    public void setSessionHolderProviderManager(SessionHolderProviderManager sessionHolderProviderManager) {
        this.sessionHolderProviderManager = sessionHolderProviderManager;
    }

    public void setKeepNewNamespaces(boolean keepNamespaces) {
        this.keepNewNamespaces = keepNamespaces;
    }

    public void setForceNamespacesRegistration(boolean forceNamespacesRegistration) {
        this.forceNamespacesRegistration = forceNamespacesRegistration;
    }

    public void setSkipExistingNamespaces(boolean skipRegisteredNamespace) {
        this.skipExistingNamespaces = skipRegisteredNamespace;
    }

    public boolean isForceNamespacesRegistration() {
        return this.forceNamespacesRegistration;
    }

    public boolean isKeepNewNamespaces() {
        return this.keepNewNamespaces;
    }

    public boolean isSkipExistingNamespaces() {
        return this.skipExistingNamespaces;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

