/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.springframework.core.CollectionFactory;
import org.springframework.dao.DataAccessException;
import org.springmodules.jcr.JcrAccessor;
import org.springmodules.jcr.JcrCallback;
import org.springmodules.jcr.JcrOperations;
import org.springmodules.jcr.JcrSystemException;
import org.springmodules.jcr.SessionFactory;
import org.springmodules.jcr.SessionFactoryUtils;
import org.xml.sax.ContentHandler;

public class JcrTemplate
extends JcrAccessor
implements JcrOperations {
    private boolean allowCreate = false;
    private boolean exposeNativeSession = false;
    static /* synthetic */ Class class$javax$jcr$Session;

    public JcrTemplate() {
    }

    public JcrTemplate(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.afterPropertiesSet();
    }

    public Object execute(JcrCallback action, boolean exposeNativeSession) throws DataAccessException {
        Session session = this.getSession();
        boolean existingTransaction = SessionFactoryUtils.isSessionThreadBound(session, this.getSessionFactory());
        if (existingTransaction) {
            this.logger.debug((Object)"Found thread-bound Session for JcrTemplate");
        }
        try {
            Object result;
            Session sessionToExpose = exposeNativeSession ? session : this.createSessionProxy(session);
            Object object = result = action.doInJcr(sessionToExpose);
            return object;
        }
        catch (RepositoryException ex) {
            throw this.convertJcrAccessException(ex);
        }
        catch (IOException ex) {
            throw this.convertJcrAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw this.convertJcrAccessException(ex);
        }
        finally {
            if (existingTransaction) {
                this.logger.debug((Object)"Not closing pre-bound Jcr Session after JcrTemplate");
            } else {
                SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
            }
        }
    }

    public Object execute(JcrCallback callback) throws DataAccessException {
        return this.execute(callback, this.isExposeNativeSession());
    }

    protected Session getSession() {
        return SessionFactoryUtils.getSession(this.getSessionFactory(), this.allowCreate);
    }

    public void addLockToken(final String lock) {
        this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                session.addLockToken(lock);
                return null;
            }
        }, true);
    }

    public Object getAttribute(final String name) {
        return this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getAttribute(name);
            }
        }, true);
    }

    public String[] getAttributeNames() {
        return (String[])this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getAttributeNames();
            }
        }, true);
    }

    public ContentHandler getImportContentHandler(final String parentAbsPath, final int uuidBehavior) {
        return (ContentHandler)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getImportContentHandler(parentAbsPath, uuidBehavior);
            }
        }, true);
    }

    public Item getItem(final String absPath) {
        return (Item)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getItem(absPath);
            }
        }, true);
    }

    public String[] getLockTokens() {
        return (String[])this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getLockTokens();
            }
        }, true);
    }

    public String getNamespacePrefix(final String uri) {
        return (String)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getNamespacePrefix(uri);
            }
        }, true);
    }

    public String[] getNamespacePrefixes() {
        return (String[])this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getNamespacePrefixes();
            }
        }, true);
    }

    public String getNamespaceURI(final String prefix) {
        return (String)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getNamespaceURI(prefix);
            }
        }, true);
    }

    public Node getNodeByUUID(final String uuid) {
        return (Node)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getNodeByUUID(uuid);
            }
        }, true);
    }

    public Node getRootNode() {
        return (Node)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getRootNode();
            }
        }, true);
    }

    public String getUserID() {
        return (String)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getUserID();
            }
        }, true);
    }

    public ValueFactory getValueFactory() {
        return (ValueFactory)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getValueFactory();
            }
        }, true);
    }

    public boolean hasPendingChanges() {
        return (Boolean)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return new Boolean(session.hasPendingChanges());
            }
        }, true);
    }

    public void importXML(final String parentAbsPath, final InputStream in, final int uuidBehavior) {
        this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                try {
                    session.importXML(parentAbsPath, in, uuidBehavior);
                }
                catch (IOException e) {
                    throw new JcrSystemException(e);
                }
                return null;
            }
        }, true);
    }

    public void refresh(final boolean keepChanges) {
        this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                session.refresh(keepChanges);
                return null;
            }
        }, true);
    }

    public void removeLockToken(final String lt) {
        this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                session.removeLockToken(lt);
                return null;
            }
        }, true);
    }

    public void rename(final Node node, final String newName) {
        this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                session.move(node.getPath(), node.getParent().getPath() + "/" + newName);
                return null;
            }
        }, true);
    }

    public void setNamespacePrefix(final String prefix, final String uri) {
        this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                session.setNamespacePrefix(prefix, uri);
                return null;
            }
        }, true);
    }

    public boolean isLive() {
        return (Boolean)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return new Boolean(session.isLive());
            }
        }, true);
    }

    public boolean itemExists(final String absPath) {
        return (Boolean)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return new Boolean(session.itemExists(absPath));
            }
        }, true);
    }

    public void move(final String srcAbsPath, final String destAbsPath) {
        this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                session.move(srcAbsPath, destAbsPath);
                return null;
            }
        }, true);
    }

    public void save() {
        this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                session.save();
                return null;
            }
        }, true);
    }

    public String dump(final Node node) {
        return (String)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                Node nd = node;
                if (nd == null) {
                    nd = session.getRootNode();
                }
                return JcrTemplate.this.dumpNode(nd);
            }
        }, true);
    }

    protected String dumpNode(Node node) throws RepositoryException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(node.getPath());
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            buffer.append(property.getPath() + "=");
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(values[i].getString());
                }
            } else {
                buffer.append(property.getString());
            }
            buffer.append("\n");
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node child = nodes.nextNode();
            buffer.append(this.dumpNode(child));
        }
        return buffer.toString();
    }

    public QueryResult query(final Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node can't be null");
        }
        return (QueryResult)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                boolean debug = JcrTemplate.this.logger.isDebugEnabled();
                QueryManager manager = session.getWorkspace().getQueryManager();
                if (debug) {
                    JcrTemplate.this.logger.debug((Object)("retrieved manager " + manager));
                }
                Query query = manager.getQuery(node);
                if (debug) {
                    JcrTemplate.this.logger.debug((Object)("created query " + query));
                }
                return query.execute();
            }
        }, true);
    }

    public QueryResult query(String statement) {
        return this.query(statement, null);
    }

    public QueryResult query(final String statement, final String language) {
        if (statement == null) {
            throw new IllegalArgumentException("statement can't be null");
        }
        return (QueryResult)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                String lang = language;
                if (lang == null) {
                    lang = "xpath";
                }
                boolean debug = JcrTemplate.this.logger.isDebugEnabled();
                QueryManager manager = session.getWorkspace().getQueryManager();
                if (debug) {
                    JcrTemplate.this.logger.debug((Object)("retrieved manager " + manager));
                }
                Query query = manager.createQuery(statement, lang);
                if (debug) {
                    JcrTemplate.this.logger.debug((Object)("created query " + query));
                }
                return query.execute();
            }
        }, true);
    }

    public Map query(List list) {
        return this.query(list, null, false);
    }

    public Map query(final List list, final String language, final boolean ignoreErrors) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null");
        }
        return (Map)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                String lang = language;
                if (lang == null) {
                    lang = "xpath";
                }
                boolean debug = JcrTemplate.this.logger.isDebugEnabled();
                Map map = CollectionFactory.createLinkedMapIfPossible((int)list.size());
                QueryManager manager = session.getWorkspace().getQueryManager();
                if (debug) {
                    JcrTemplate.this.logger.debug((Object)("retrieved manager " + manager));
                }
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    String statement = (String)iter.next();
                    Query query = manager.createQuery(statement, lang);
                    if (debug) {
                        JcrTemplate.this.logger.debug((Object)("created query " + query));
                    }
                    try {
                        QueryResult result = query.execute();
                        map.put(statement, result);
                    }
                    catch (RepositoryException e) {
                        if (ignoreErrors) {
                            map.put(statement, null);
                            continue;
                        }
                        throw JcrTemplate.this.convertJcrAccessException(e);
                    }
                }
                return map;
            }
        }, true);
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    protected Session createSessionProxy(Session session) {
        return (Session)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$javax$jcr$Session == null ? (class$javax$jcr$Session = JcrTemplate.class$("javax.jcr.Session")) : class$javax$jcr$Session}, (InvocationHandler)new LogoutSuppressingInvocationHandler(session));
    }

    protected boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    public boolean isExposeNativeSession() {
        return this.exposeNativeSession;
    }

    public void setExposeNativeSession(boolean exposeNativeSession) {
        this.exposeNativeSession = exposeNativeSession;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LogoutSuppressingInvocationHandler
    implements InvocationHandler {
        private final Session target;

        public LogoutSuppressingInvocationHandler(Session target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("logout")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

