/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jcr;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springmodules.jcr.JcrSessionFactory;
import org.springmodules.jcr.JcrUtils;
import org.springmodules.jcr.SessionFactory;
import org.springmodules.jcr.SessionFactoryUtils;
import org.springmodules.jcr.SessionHolderProviderManager;

public class TransactionAwareRepository
implements InitializingBean,
FactoryBean {
    private JcrSessionFactory sessionFactory;
    private Repository proxy;
    private SessionHolderProviderManager sessionHolderProviderManager;
    private boolean allowCreate = true;
    private boolean allowNonTxRepository = false;
    static /* synthetic */ Class class$javax$jcr$Repository;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$jcr$Credentials;

    public Object getObject() throws Exception {
        return this.proxy;
    }

    public Class getObjectType() {
        return class$javax$jcr$Repository == null ? (class$javax$jcr$Repository = TransactionAwareRepository.class$("javax.jcr.Repository")) : class$javax$jcr$Repository;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
        if (!this.allowNonTxRepository && !JcrUtils.supportsTransactions(this.sessionFactory.getRepository())) {
            throw new IllegalArgumentException(this.sessionFactory.toString() + " does NOT support transactions and allowNonTxRepository is false");
        }
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowNonTxRepository() {
        return this.allowNonTxRepository;
    }

    public void setAllowNonTxRepository(boolean allowNonTxRepository) {
        this.allowNonTxRepository = allowNonTxRepository;
    }

    public void setTargetFactory(JcrSessionFactory target) {
        this.sessionFactory = target;
        this.proxy = (Repository)Proxy.newProxyInstance((class$javax$jcr$Repository == null ? (class$javax$jcr$Repository = TransactionAwareRepository.class$("javax.jcr.Repository")) : class$javax$jcr$Repository).getClassLoader(), new Class[]{class$javax$jcr$Repository == null ? (class$javax$jcr$Repository = TransactionAwareRepository.class$("javax.jcr.Repository")) : class$javax$jcr$Repository}, (InvocationHandler)new TransactionAwareRepositoryInvocationHandler());
    }

    public Repository getTargetRepository() {
        return this.sessionFactory.getRepository();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final Session target;
        private final SessionFactory sessionFactory;

        public TransactionAwareInvocationHandler(Session target, SessionFactory sessionFactory) {
            this.target = target;
            this.sessionFactory = sessionFactory;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("logout")) {
                if (this.sessionFactory != null) {
                    SessionFactoryUtils.releaseSession(this.target, this.sessionFactory);
                }
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private class TransactionAwareRepositoryInvocationHandler
    implements InvocationHandler {
        private TransactionAwareRepositoryInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("login")) {
                boolean matched = false;
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length == 0) {
                    matched = TransactionAwareRepository.this.sessionFactory.getWorkspaceName() == null && TransactionAwareRepository.this.sessionFactory.getCredentials() == null;
                } else if (paramTypes.length == 1) {
                    if (paramTypes[0] == (class$java$lang$String == null ? (class$java$lang$String = TransactionAwareRepository.class$("java.lang.String")) : class$java$lang$String)) {
                        matched = ObjectUtils.nullSafeEquals((Object)args[0], (Object)TransactionAwareRepository.this.sessionFactory.getWorkspaceName());
                    }
                    if ((class$javax$jcr$Credentials == null ? (class$javax$jcr$Credentials = TransactionAwareRepository.class$("javax.jcr.Credentials")) : class$javax$jcr$Credentials).isAssignableFrom(paramTypes[0])) {
                        matched = ObjectUtils.nullSafeEquals((Object)args[0], (Object)TransactionAwareRepository.this.sessionFactory.getCredentials());
                    }
                } else if (paramTypes.length == 2) {
                    boolean bl = matched = ObjectUtils.nullSafeEquals((Object)args[0], (Object)TransactionAwareRepository.this.sessionFactory.getCredentials()) && ObjectUtils.nullSafeEquals((Object)args[1], (Object)TransactionAwareRepository.this.sessionFactory.getWorkspaceName());
                }
                if (matched) {
                    Session session = SessionFactoryUtils.getSession(TransactionAwareRepository.this.sessionFactory, TransactionAwareRepository.this.isAllowCreate());
                    Class[] ifcs = ClassUtils.getAllInterfaces((Object)session);
                    return (Session)Proxy.newProxyInstance(this.getClass().getClassLoader(), ifcs, (InvocationHandler)new TransactionAwareInvocationHandler(session, TransactionAwareRepository.this.sessionFactory));
                }
            } else {
                if (method.getName().equals("equals")) {
                    return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(this.hashCode());
                }
            }
            Repository target = TransactionAwareRepository.this.getTargetRepository();
            try {
                return method.invoke((Object)target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

