/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jcr.jackrabbit;

import javax.jcr.Repository;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;

public class RepositoryFactoryBean
extends org.springmodules.jcr.RepositoryFactoryBean {
    private static final String DEFAULT_CONF_FILE = "repository.xml";
    private static final String DEFAULT_REP_DIR = ".";
    private Resource homeDir;
    private RepositoryConfig repositoryConfig;

    protected Repository createRepository() throws Exception {
        return RepositoryImpl.create((RepositoryConfig)this.repositoryConfig);
    }

    protected void resolveConfigurationResource() throws Exception {
        if (this.repositoryConfig != null) {
            return;
        }
        if (this.configuration == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"no configuration resource specified, using the default one:repository.xml");
            }
            this.configuration = new ClassPathResource(DEFAULT_CONF_FILE);
        }
        if (this.homeDir == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"no repository home dir specified, using the default one:.");
            }
            this.homeDir = new FileSystemResource(DEFAULT_REP_DIR);
        }
        this.repositoryConfig = RepositoryConfig.create((InputSource)new InputSource(this.configuration.getInputStream()), (String)this.homeDir.getFile().getAbsolutePath());
    }

    public void destroy() throws Exception {
        if (this.repository instanceof JackrabbitRepository) {
            ((JackrabbitRepository)this.repository).shutdown();
        }
    }

    public Resource getHomeDir() {
        return this.homeDir;
    }

    public void setHomeDir(Resource defaultRepDir) {
        this.homeDir = defaultRepDir;
    }

    public RepositoryConfig getRepositoryConfig() {
        return this.repositoryConfig;
    }

    public void setRepositoryConfig(RepositoryConfig repositoryConfig) {
        this.repositoryConfig = repositoryConfig;
    }
}

