/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jcr.support;

import java.io.IOException;
import javax.jcr.Session;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springmodules.jcr.SessionFactory;
import org.springmodules.jcr.SessionFactoryUtils;

public class OpenSessionInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_JCR_SESSION_FACTORY_FACTORY_BEAN_NAME = "sessionFactory";
    private String SessionFactoryBeanName = "sessionFactory";
    static /* synthetic */ Class class$org$springmodules$jcr$SessionFactory;

    public void setSessionFactoryBeanName(String SessionFactoryBeanName) {
        this.SessionFactoryBeanName = SessionFactoryBeanName;
    }

    protected String getSessionFactoryBeanName() {
        return this.SessionFactoryBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SessionFactory sf = this.lookupSessionFactory(request);
        Session session = null;
        boolean participate = false;
        if (TransactionSynchronizationManager.hasResource((Object)sf)) {
            participate = true;
        } else {
            this.logger.debug((Object)"Opening JCR session in OpenSessionInViewFilter");
            session = SessionFactoryUtils.getSession(sf, true);
            TransactionSynchronizationManager.bindResource((Object)sf, (Object)((Object)sf.getSessionHolder(session)));
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (!participate) {
                TransactionSynchronizationManager.unbindResource((Object)sf);
                this.logger.debug((Object)"Closing JCR session in OpenSessionInViewFilter");
                SessionFactoryUtils.releaseSession(session, sf);
            }
        }
    }

    protected SessionFactory lookupSessionFactory(HttpServletRequest request) {
        return this.lookupSessionFactory();
    }

    protected SessionFactory lookupSessionFactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using session factory '" + this.getSessionFactoryBeanName() + "' for OpenSessionInViewFilter"));
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (SessionFactory)wac.getBean(this.getSessionFactoryBeanName(), class$org$springmodules$jcr$SessionFactory == null ? (class$org$springmodules$jcr$SessionFactory = OpenSessionInViewFilter.class$("org.springmodules.jcr.SessionFactory")) : class$org$springmodules$jcr$SessionFactory);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

