/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.valang;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springmodules.validation.valang.CustomPropertyEditor;
import org.springmodules.validation.valang.parser.SimpleValangBased;
import org.springmodules.validation.valang.parser.ValangParser;
import org.springmodules.validation.valang.predicates.ValidationRule;

public class ValangValidator
extends SimpleValangBased
implements Validator,
InitializingBean {
    private String valang = null;
    private Collection customPropertyEditors = null;
    private Map dateParserRegistrations = null;
    private Map customFunctions = null;
    private Collection rules = null;

    public void setValang(String valang) {
        this.valang = valang;
    }

    public void setCustomPropertyEditors(Collection customPropertyEditors) {
        this.customPropertyEditors = customPropertyEditors;
    }

    public void setDateParserRegistrations(Map dateParserRegistrations) {
        this.setDateParsers(dateParserRegistrations);
    }

    private Map getDateParserRegistrations() {
        return this.dateParserRegistrations;
    }

    public void setDateParsers(Map parserByRegexp) {
        this.dateParserRegistrations = parserByRegexp;
    }

    public void setCustomFunctions(Map customFunctions) {
        this.customFunctions = customFunctions;
    }

    public void addCustomFunction(String functionName, String functionClassName) {
        this.customFunctions.put(functionName, functionClassName);
    }

    private Map getCustomFunctions() {
        return this.customFunctions;
    }

    private Collection getCustomPropertyEditors() {
        return this.customPropertyEditors;
    }

    private String getValang() {
        return this.valang;
    }

    public Collection getRules() {
        return this.rules;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.getValang(), (String)"'valang' property must be set!");
        ValangParser parser = new ValangParser(this.getValang());
        this.initLifecycle(parser.getVisitor());
        parser.setDateParsersByRegexp(this.getDateParserRegistrations());
        parser.setFunctionsByName(this.getAllCustomFunctions());
        this.rules = parser.parseValidation();
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public void validate(Object target, Errors errors) {
        Iterator iter;
        BeanWrapper beanWrapper;
        Object object = beanWrapper = target instanceof BeanWrapper ? (BeanWrapper)target : new BeanWrapperImpl(target);
        if (this.getCustomPropertyEditors() != null) {
            iter = this.getCustomPropertyEditors().iterator();
            while (iter.hasNext()) {
                CustomPropertyEditor customPropertyEditor = (CustomPropertyEditor)iter.next();
                if (customPropertyEditor.getRequiredType() == null) {
                    throw new IllegalArgumentException("[requiredType] is required on CustomPropertyEditor instances!");
                }
                if (customPropertyEditor.getPropertyEditor() == null) {
                    throw new IllegalArgumentException("[propertyEditor] is required on CustomPropertyEditor instances!");
                }
                if (StringUtils.hasLength((String)customPropertyEditor.getPropertyPath())) {
                    beanWrapper.registerCustomEditor(customPropertyEditor.getRequiredType(), customPropertyEditor.getPropertyPath(), customPropertyEditor.getPropertyEditor());
                    continue;
                }
                beanWrapper.registerCustomEditor(customPropertyEditor.getRequiredType(), customPropertyEditor.getPropertyEditor());
            }
        }
        iter = this.rules.iterator();
        while (iter.hasNext()) {
            ValidationRule rule = (ValidationRule)iter.next();
            rule.validate(beanWrapper, errors);
        }
    }
}

