/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.annotation.handler;

import java.lang.annotation.Annotation;
import org.springframework.util.StringUtils;
import org.springmodules.validation.bean.conf.MutableBeanValidationConfiguration;
import org.springmodules.validation.bean.conf.loader.annotation.handler.ClassValidationAnnotationHandler;
import org.springmodules.validation.bean.rule.AbstractValidationRule;
import org.springmodules.validation.bean.rule.resolver.ErrorArgumentsResolver;
import org.springmodules.validation.bean.rule.resolver.FunctionErrorArgumentsResolver;
import org.springmodules.validation.util.cel.ConditionExpressionBased;
import org.springmodules.validation.util.cel.ConditionExpressionParser;
import org.springmodules.validation.util.cel.valang.ValangConditionExpressionParser;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.util.fel.FunctionExpressionBased;
import org.springmodules.validation.util.fel.FunctionExpressionParser;
import org.springmodules.validation.util.fel.parser.ValangFunctionExpressionParser;

public abstract class AbstractClassValidationAnnotationHandler
implements ClassValidationAnnotationHandler,
ConditionExpressionBased,
FunctionExpressionBased {
    public static final String APPLY_IF_ATTR = "applyIf";
    public static final String ERROR_CODE_ATTR = "errorCode";
    public static final String MESSAGE_ATTR = "message";
    public static final String ARGS_ATTR = "args";
    private Class[] supportedAnnotationTypes;
    private ConditionExpressionParser conditionExpressionParser;
    private FunctionExpressionParser functionExpressionParser;

    public AbstractClassValidationAnnotationHandler(Class ... supportedAnnotationTypes) {
        this.supportedAnnotationTypes = supportedAnnotationTypes;
        this.conditionExpressionParser = new ValangConditionExpressionParser();
        this.functionExpressionParser = new ValangFunctionExpressionParser();
    }

    public boolean supports(Annotation annotation, Class clazz) {
        for (Class supportedType : this.supportedAnnotationTypes) {
            if (!supportedType.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public void handleAnnotation(Annotation annotation, Class clazz, MutableBeanValidationConfiguration configuration) {
        Condition applicabilityCondition;
        ErrorArgumentsResolver argumentsResolver;
        String message;
        AbstractValidationRule rule = this.createValidationRule(annotation, clazz);
        String errorCode = this.extractErrorCode(annotation);
        if (errorCode != null) {
            rule.setErrorCode(errorCode);
        }
        if ((message = this.extractDefaultMessage(annotation)) != null) {
            rule.setDefaultErrorMessage(message);
        }
        if ((argumentsResolver = this.extractArgumentsResolver(annotation)) != null) {
            rule.setErrorArgumentsResolver(argumentsResolver);
        }
        if ((applicabilityCondition = this.extractApplicabilityContidion(annotation)) != null) {
            rule.setApplicabilityCondition(applicabilityCondition);
        }
        configuration.addGlobalRule(rule);
    }

    protected String extractErrorCode(Annotation annotation) {
        return (String)this.extractAnnotationAttribute(annotation, ERROR_CODE_ATTR);
    }

    protected String extractDefaultMessage(Annotation annotation) {
        return (String)this.extractAnnotationAttribute(annotation, MESSAGE_ATTR);
    }

    protected ErrorArgumentsResolver extractArgumentsResolver(Annotation annotation) {
        String argsAsString = (String)this.extractAnnotationAttribute(annotation, ARGS_ATTR);
        argsAsString = argsAsString == null ? "" : argsAsString;
        String[] argsExpressions = StringUtils.commaDelimitedListToStringArray((String)argsAsString);
        if (argsExpressions.length == 0) {
            return null;
        }
        return new FunctionErrorArgumentsResolver(argsExpressions, this.functionExpressionParser);
    }

    protected Condition extractApplicabilityContidion(Annotation annotation) {
        String expression = (String)this.extractAnnotationAttribute(annotation, APPLY_IF_ATTR);
        return StringUtils.hasText((String)expression) ? this.conditionExpressionParser.parse(expression) : null;
    }

    protected abstract AbstractValidationRule createValidationRule(Annotation var1, Class var2);

    public void setConditionExpressionParser(ConditionExpressionParser conditionExpressionParser) {
        this.conditionExpressionParser = conditionExpressionParser;
    }

    protected ConditionExpressionParser getConditionExpressionParser() {
        return this.conditionExpressionParser;
    }

    public void setFunctionExpressionParser(FunctionExpressionParser functionExpressionParser) {
        this.functionExpressionParser = functionExpressionParser;
    }

    protected FunctionExpressionParser getFunctionExpressionParser() {
        return this.functionExpressionParser;
    }

    protected Object extractAnnotationAttribute(Annotation annotation, String attributeName) {
        try {
            return annotation.getClass().getMethod(attributeName, new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expecting attribute '" + attributeName + "' in annotation '" + annotation.getClass().getName() + "'", e);
        }
    }
}

