/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.rule;

import org.springmodules.validation.bean.rule.ValidationRule;
import org.springmodules.validation.bean.rule.resolver.ErrorArgumentsResolver;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.util.condition.common.AlwaysTrueCondition;

public abstract class AbstractValidationRule
implements ValidationRule {
    private String errorCode;
    private String defaultErrorMessage;
    private ErrorArgumentsResolver errorArgumentsResolver;
    private Condition applicabilityCondition;

    protected AbstractValidationRule(String defaultErrorCode) {
        this(defaultErrorCode, AbstractValidationRule.createErrorArgumentsResolver(new Object[0]));
    }

    protected AbstractValidationRule(String defaultErrorCode, ErrorArgumentsResolver defaultErrorArgumentsResolver) {
        this.defaultErrorMessage = this.errorCode = defaultErrorCode;
        this.errorArgumentsResolver = defaultErrorArgumentsResolver;
        this.applicabilityCondition = new AlwaysTrueCondition();
    }

    public boolean isApplicable(Object obj) {
        if (obj == null && !this.supportsNullValues()) {
            return false;
        }
        return this.applicabilityCondition.check(obj);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Object[] getErrorArguments(Object obj) {
        return this.errorArgumentsResolver.resolveArguments(obj);
    }

    public String getDefaultErrorMessage() {
        return this.defaultErrorMessage;
    }

    protected boolean supportsNullValues() {
        return false;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setDefaultErrorMessage(String defaultErrorMessage) {
        this.defaultErrorMessage = defaultErrorMessage;
    }

    public void setErrorArgumentsResolver(ErrorArgumentsResolver errorArgumentsResolver) {
        this.errorArgumentsResolver = errorArgumentsResolver;
    }

    public void setApplicabilityCondition(Condition applicabilityCondition) {
        this.applicabilityCondition = applicabilityCondition;
    }

    protected static ErrorArgumentsResolver createErrorArgumentsResolver(Object arg) {
        return AbstractValidationRule.createErrorArgumentsResolver(new Object[]{arg});
    }

    protected static ErrorArgumentsResolver createErrorArgumentsResolver(Object arg1, Object arg2) {
        return AbstractValidationRule.createErrorArgumentsResolver(new Object[]{arg1, arg2});
    }

    protected static ErrorArgumentsResolver createErrorArgumentsResolver(Object arg1, Object arg2, Object arg3) {
        return AbstractValidationRule.createErrorArgumentsResolver(new Object[]{arg1, arg2, arg3});
    }

    protected static ErrorArgumentsResolver createErrorArgumentsResolver(final Object[] arguments) {
        return new ErrorArgumentsResolver(){

            public Object[] resolveArguments(Object obj) {
                Object[] result = new Object[arguments.length + 1];
                System.arraycopy(arguments, 0, result, 1, arguments.length);
                result[0] = obj;
                return result;
            }
        };
    }
}

