/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.valang.parser;

import javax.servlet.ServletContext;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.JdkVersion;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.ServletContextAware;
import org.springmodules.validation.util.date.DefaultDateParser;
import org.springmodules.validation.valang.ValangException;
import org.springmodules.validation.valang.functions.AbstractFunction;
import org.springmodules.validation.valang.functions.AbstractInitializableFunction;
import org.springmodules.validation.valang.functions.EmailFunction;
import org.springmodules.validation.valang.functions.Function;
import org.springmodules.validation.valang.functions.InRoleFunction;
import org.springmodules.validation.valang.functions.LengthOfFunction;
import org.springmodules.validation.valang.functions.LowerCaseFunction;
import org.springmodules.validation.valang.functions.NotFunction;
import org.springmodules.validation.valang.functions.RegExFunction;
import org.springmodules.validation.valang.functions.ResolveFunction;
import org.springmodules.validation.valang.functions.UpperCaseFunction;
import org.springmodules.validation.valang.parser.ValangVisitor;
import org.springmodules.validation.valang.predicates.GenericTestPredicate;
import org.springmodules.validation.valang.predicates.Operator;

public class DefaultVisitor
implements ValangVisitor,
BeanFactoryAware,
ApplicationContextAware,
ResourceLoaderAware,
MessageSourceAware,
ApplicationEventPublisherAware,
ServletContextAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springmodules$validation$valang$parser$DefaultVisitor == null ? (class$org$springmodules$validation$valang$parser$DefaultVisitor = DefaultVisitor.class$("org.springmodules.validation.valang.parser.DefaultVisitor")) : class$org$springmodules$validation$valang$parser$DefaultVisitor));
    private ValangVisitor visitor = null;
    private DefaultDateParser dateParser = null;
    private BeanFactory beanFactory = null;
    private ApplicationContext applicationContext = null;
    private ResourceLoader resourceLoader = null;
    private MessageSource messageSource = null;
    private ApplicationEventPublisher applicationEventPublisher = null;
    private ServletContext servletContext = null;
    static /* synthetic */ Class class$org$springmodules$validation$valang$parser$DefaultVisitor;
    static /* synthetic */ Class class$org$springmodules$validation$valang$functions$AbstractInitializableFunction;

    public DefaultVisitor() {
        if (JdkVersion.getMajorJavaVersion() != 0) {
            this.dateParser = new DefaultDateParser();
        }
    }

    public Function getFunction(String name, Function[] arguments, int line, int column) {
        return this.lifeCycleCallbacks(this.doGetFunction(name, arguments, line, column), line, column);
    }

    private Function doGetFunction(String name, Function[] arguments, int line, int column) {
        Function function = this.resolveCustomFunction(name, arguments, line, column);
        if (function != null) {
            return function;
        }
        function = this.resolveFunctionFromApplicationContext(name, arguments, line, column);
        if (function != null) {
            return function;
        }
        function = this.resolveDefaultFunction(name, arguments, line, column);
        if (function != null) {
            return function;
        }
        throw new ValangException("Could not find function [" + name + "]", line, column);
    }

    private Function resolveCustomFunction(String name, Function[] arguments, int line, int column) {
        if (this.getVisitor() == null) {
            return null;
        }
        return this.getVisitor().getFunction(name, arguments, line, column);
    }

    private Function resolveFunctionFromApplicationContext(String name, Function[] arguments, int line, int column) {
        Object bean;
        if (this.applicationContext == null || !this.applicationContext.containsBean(name)) {
            return null;
        }
        if (!(class$org$springmodules$validation$valang$functions$AbstractInitializableFunction == null ? (class$org$springmodules$validation$valang$functions$AbstractInitializableFunction = DefaultVisitor.class$("org.springmodules.validation.valang.functions.AbstractInitializableFunction")) : class$org$springmodules$validation$valang$functions$AbstractInitializableFunction).isInstance(bean = this.applicationContext.getBean(name))) {
            logger.warn((Object)("Bean '" + name + "' is not of a '" + (class$org$springmodules$validation$valang$functions$AbstractInitializableFunction == null ? (class$org$springmodules$validation$valang$functions$AbstractInitializableFunction = DefaultVisitor.class$("org.springmodules.validation.valang.functions.AbstractInitializableFunction")) : class$org$springmodules$validation$valang$functions$AbstractInitializableFunction).getName() + "' type"));
            return null;
        }
        AbstractInitializableFunction function = (AbstractInitializableFunction)bean;
        function.init(arguments, line, column);
        return function;
    }

    private Function resolveDefaultFunction(String name, Function[] arguments, int line, int column) {
        if ("len".equals(name) || "length".equals(name) || "size".equals(name) || "count".equals(name)) {
            return new LengthOfFunction(arguments, line, column);
        }
        if ("upper".equals(name)) {
            return new UpperCaseFunction(arguments, line, column);
        }
        if ("lower".equals(name)) {
            return new LowerCaseFunction(arguments, line, column);
        }
        if ("!".equals(name)) {
            return new NotFunction(arguments, line, column);
        }
        if ("resolve".equals(name)) {
            return new ResolveFunction(arguments, line, column);
        }
        if ("match".equals(name) || "matches".equals(name)) {
            return new RegExFunction(arguments, line, column);
        }
        if ("inRole".equals(name)) {
            return new InRoleFunction(arguments, line, column);
        }
        if ("email".equals(name)) {
            return new EmailFunction(arguments, line, column);
        }
        return null;
    }

    private Function lifeCycleCallbacks(Function function, int line, int column) {
        if (function instanceof BeanFactoryAware) {
            ((BeanFactoryAware)function).setBeanFactory(this.beanFactory);
        }
        if (function instanceof ApplicationContextAware) {
            ((ApplicationContextAware)function).setApplicationContext(this.applicationContext);
        }
        if (function instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)function).setResourceLoader(this.resourceLoader);
        }
        if (function instanceof MessageSourceAware) {
            ((MessageSourceAware)function).setMessageSource(this.messageSource);
        }
        if (function instanceof ApplicationEventPublisherAware) {
            ((ApplicationEventPublisherAware)function).setApplicationEventPublisher(this.applicationEventPublisher);
        }
        if (function instanceof ServletContextAware) {
            ((ServletContextAware)function).setServletContext(this.servletContext);
        }
        if (function instanceof AbstractFunction) {
            AbstractFunction abstractFunction = (AbstractFunction)function;
            ConfigurableListableBeanFactory autowireCapableBeanFactory = null;
            if (abstractFunction.isAutowireByName() || abstractFunction.isAutowireByType()) {
                if (this.applicationContext instanceof ConfigurableApplicationContext) {
                    ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.applicationContext;
                    autowireCapableBeanFactory = configurableApplicationContext.getBeanFactory();
                } else if (this.beanFactory instanceof AutowireCapableBeanFactory) {
                    autowireCapableBeanFactory = (AutowireCapableBeanFactory)this.beanFactory;
                } else {
                    if (this.applicationContext == null && this.beanFactory == null) {
                        throw new ValangException("Could not autowire function: no application context or bean factory available", line, column);
                    }
                    throw new ValangException("Could not autowire function: application context or bean factory does not support autowiring", line, column);
                }
            }
            if (abstractFunction.isAutowireByName()) {
                autowireCapableBeanFactory.autowireBeanProperties((Object)function, 1, false);
            }
            if (abstractFunction.isAutowireByType()) {
                autowireCapableBeanFactory.autowireBeanProperties((Object)function, 2, false);
            }
            try {
                abstractFunction.init();
            }
            catch (Exception e) {
                throw new ValangException("Error initializing function", e, line, column);
            }
        }
        return function;
    }

    public void setVisitor(ValangVisitor visitor) {
        this.visitor = visitor;
    }

    public ValangVisitor getVisitor() {
        return this.visitor;
    }

    public Predicate getPredicate(Function leftFunction, Operator operator, Function rightFunction, int line, int column) {
        return new GenericTestPredicate(leftFunction, operator, rightFunction, line, column);
    }

    public DefaultDateParser getDateParser() {
        if (this.dateParser == null) {
            throw new IllegalStateException("Date parser not supported in Java 1.3 or older.");
        }
        return this.dateParser;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

