/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth.gattparser;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sputnikdev.bluetooth.gattparser.CharacteristicFormatException;
import org.sputnikdev.bluetooth.gattparser.CharacteristicParser;
import org.sputnikdev.bluetooth.gattparser.FieldHolder;
import org.sputnikdev.bluetooth.gattparser.GattRequest;
import org.sputnikdev.bluetooth.gattparser.GattResponse;
import org.sputnikdev.bluetooth.gattparser.GenericCharacteristicParser;
import org.sputnikdev.bluetooth.gattparser.spec.BluetoothGattSpecificationReader;
import org.sputnikdev.bluetooth.gattparser.spec.Characteristic;
import org.sputnikdev.bluetooth.gattparser.spec.Field;
import org.sputnikdev.bluetooth.gattparser.spec.Service;

public class BluetoothGattParser {
    private final Logger logger = LoggerFactory.getLogger(GenericCharacteristicParser.class);
    private BluetoothGattSpecificationReader specificationReader;
    private final Map<String, CharacteristicParser> customParsers = new HashMap<String, CharacteristicParser>();
    private CharacteristicParser defaultParser;

    BluetoothGattParser(BluetoothGattSpecificationReader specificationReader, CharacteristicParser defaultParser) {
        this.specificationReader = specificationReader;
        this.defaultParser = defaultParser;
    }

    public boolean isKnownCharacteristic(String characteristicUUID) {
        return this.specificationReader.getCharacteristicByUUID(this.getShortUUID(characteristicUUID)) != null;
    }

    public boolean isKnownService(String serviceUUID) {
        return this.specificationReader.getService(this.getShortUUID(serviceUUID)) != null;
    }

    public GattResponse parse(String characteristicUUID, byte[] raw) throws CharacteristicFormatException {
        return new GattResponse(this.parseFields(characteristicUUID, raw));
    }

    public GattRequest prepare(String characteristicUUID) {
        characteristicUUID = this.getShortUUID(characteristicUUID);
        return new GattRequest(characteristicUUID, this.specificationReader.getFields(this.specificationReader.getCharacteristicByUUID(characteristicUUID)));
    }

    public GattRequest prepare(String characteristicUUID, byte[] initial) {
        characteristicUUID = this.getShortUUID(characteristicUUID);
        return new GattRequest(characteristicUUID, this.parseFields(characteristicUUID, initial));
    }

    public byte[] serialize(GattRequest gattRequest) {
        return this.serialize(gattRequest, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(GattRequest gattRequest, boolean strict) {
        if (strict && !this.validate(gattRequest)) {
            throw new IllegalArgumentException("GATT request is not valid");
        }
        Map<String, CharacteristicParser> map = this.customParsers;
        synchronized (map) {
            String characteristicUUID = this.getShortUUID(gattRequest.getCharacteristicUUID());
            if (strict && !this.isValidForWrite(characteristicUUID)) {
                throw new CharacteristicFormatException("Characteristic is not valid for write: " + characteristicUUID);
            }
            if (this.customParsers.containsKey(characteristicUUID)) {
                return this.customParsers.get(characteristicUUID).serialize(gattRequest.getAllFieldHolders());
            }
            return this.defaultParser.serialize(gattRequest.getAllFieldHolders());
        }
    }

    public Service getService(String serviceUUID) {
        return this.specificationReader.getService(this.getShortUUID(serviceUUID));
    }

    public Characteristic getCharacteristic(String characteristicUUID) {
        return this.specificationReader.getCharacteristicByUUID(this.getShortUUID(characteristicUUID));
    }

    public List<Field> getFields(String characteristicUUID) {
        return this.specificationReader.getFields(this.getCharacteristic(this.getShortUUID(characteristicUUID)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerParser(String characteristicUUID, CharacteristicParser parser) {
        Map<String, CharacteristicParser> map = this.customParsers;
        synchronized (map) {
            this.customParsers.put(this.getShortUUID(characteristicUUID), parser);
        }
    }

    public boolean isValidForRead(String characteristicUUID) {
        Characteristic characteristic = this.specificationReader.getCharacteristicByUUID(this.getShortUUID(characteristicUUID));
        return characteristic != null && characteristic.isValidForRead();
    }

    public boolean isValidForWrite(String characteristicUUID) {
        Characteristic characteristic = this.specificationReader.getCharacteristicByUUID(this.getShortUUID(characteristicUUID));
        return characteristic != null && characteristic.isValidForWrite();
    }

    public boolean validate(GattRequest gattRequest) {
        String requirement;
        FieldHolder controlPointField = gattRequest.getOpCodesFieldHolder();
        String string = requirement = controlPointField != null ? controlPointField.getEnumerationRequires() : null;
        if (requirement != null) {
            List<FieldHolder> required = gattRequest.getRequiredHolders(requirement);
            if (required.isEmpty()) {
                this.logger.info("GATT request is invalid; could not find any field by requirement: {}", (Object)requirement);
                return false;
            }
            for (FieldHolder holder : required) {
                if (holder.isValueSet()) continue;
                this.logger.info("GATT request is invalid; field is not set: {}", (Object)holder.getField().getName());
                return false;
            }
        }
        for (FieldHolder holder : gattRequest.getRequiredHolders("Mandatory")) {
            if (holder.isValueSet()) continue;
            this.logger.info("GATT request is invalid; field is not set: {}", (Object)holder.getField().getName());
            return false;
        }
        return true;
    }

    public void loadExtensionsFromFolder(String path) {
        this.specificationReader.loadExtensionsFromFolder(path);
    }

    public void loadExtensionsFromCatalogResources(URL servicesCatalogResource, URL characteristicsCatalogResource) throws IllegalStateException {
        this.specificationReader.loadExtensionsFromCatalogResources(servicesCatalogResource, characteristicsCatalogResource);
    }

    public String parse(byte[] raw, int radix) {
        Object[] hexFormatted = new String[raw.length];
        int index = 0;
        for (byte b : raw) {
            String num = Integer.toUnsignedString(Byte.toUnsignedInt(b), radix);
            hexFormatted[index++] = ("00" + num).substring(num.length());
        }
        return Arrays.toString(hexFormatted);
    }

    public byte[] serialize(String raw, int radix) {
        String data = raw.replace("[", "").replace("]", "");
        String[] tokens = data.split(",");
        byte[] bytes = new byte[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            bytes[i] = (byte)Integer.valueOf(tokens[i].trim(), radix).intValue();
        }
        return bytes;
    }

    private String getShortUUID(String uuid) {
        if (uuid.length() < 8) {
            return uuid.toUpperCase();
        }
        return Long.toHexString(Long.valueOf(uuid.substring(0, 8), 16)).toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap<String, FieldHolder> parseFields(String characteristicUUID, byte[] raw) {
        characteristicUUID = this.getShortUUID(characteristicUUID);
        Map<String, CharacteristicParser> map = this.customParsers;
        synchronized (map) {
            if (!this.isValidForRead(characteristicUUID)) {
                throw new CharacteristicFormatException("Characteristic is not valid for read: " + characteristicUUID);
            }
            Characteristic characteristic = this.specificationReader.getCharacteristicByUUID(characteristicUUID);
            if (this.customParsers.containsKey(characteristicUUID)) {
                return this.customParsers.get(characteristicUUID).parse(characteristic, raw);
            }
            return this.defaultParser.parse(characteristic, raw);
        }
    }
}

