/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth.gattparser;

import org.sputnikdev.bluetooth.gattparser.BluetoothGattParser;
import org.sputnikdev.bluetooth.gattparser.GenericCharacteristicParser;
import org.sputnikdev.bluetooth.gattparser.num.FloatingPointNumberFormatter;
import org.sputnikdev.bluetooth.gattparser.num.IEEE11073FloatingPointNumberFormatter;
import org.sputnikdev.bluetooth.gattparser.num.IEEE754FloatingPointNumberFormatter;
import org.sputnikdev.bluetooth.gattparser.num.RealNumberFormatter;
import org.sputnikdev.bluetooth.gattparser.num.TwosComplementNumberFormatter;
import org.sputnikdev.bluetooth.gattparser.spec.BluetoothGattSpecificationReader;

public final class BluetoothGattParserFactory {
    private static final RealNumberFormatter TWOS_COMPLEMENT_NUMBER_FORMATTER = new TwosComplementNumberFormatter();
    private static final FloatingPointNumberFormatter IEEE_754_FLOATING_POINT_NUMBER_FORMATTER = new IEEE754FloatingPointNumberFormatter();
    private static final FloatingPointNumberFormatter IEEE_11073_FLOATING_POINT_NUMBER_FORMATTER = new IEEE11073FloatingPointNumberFormatter();
    private static volatile BluetoothGattSpecificationReader reader;
    private static volatile BluetoothGattParser defaultParser;

    private BluetoothGattParserFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BluetoothGattSpecificationReader getSpecificationReader() {
        if (reader != null) return reader;
        Class<BluetoothGattParserFactory> clazz = BluetoothGattParserFactory.class;
        synchronized (BluetoothGattParserFactory.class) {
            if (reader != null) return reader;
            reader = new BluetoothGattSpecificationReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BluetoothGattParser getDefault() {
        if (defaultParser != null) return defaultParser;
        Class<BluetoothGattParserFactory> clazz = BluetoothGattParserFactory.class;
        synchronized (BluetoothGattParserFactory.class) {
            if (defaultParser != null) return defaultParser;
            BluetoothGattSpecificationReader reader = BluetoothGattParserFactory.getSpecificationReader();
            defaultParser = new BluetoothGattParser(reader, new GenericCharacteristicParser(reader));
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultParser;
        }
    }

    public static RealNumberFormatter getTwosComplementNumberFormatter() {
        return TWOS_COMPLEMENT_NUMBER_FORMATTER;
    }

    public static FloatingPointNumberFormatter getIEEE754FloatingPointNumberFormatter() {
        return IEEE_754_FLOATING_POINT_NUMBER_FORMATTER;
    }

    public static FloatingPointNumberFormatter getIEEE11073FloatingPointNumberFormatter() {
        return IEEE_11073_FLOATING_POINT_NUMBER_FORMATTER;
    }
}

