/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth.gattparser;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.sputnikdev.bluetooth.gattparser.FieldHolder;
import org.sputnikdev.bluetooth.gattparser.spec.BitField;
import org.sputnikdev.bluetooth.gattparser.spec.Enumeration;
import org.sputnikdev.bluetooth.gattparser.spec.Field;
import org.sputnikdev.bluetooth.gattparser.spec.FlagUtils;

public class GattRequest {
    private final String characteristicUUID;
    private final Map<String, FieldHolder> holders;
    private final FieldHolder opCodesHolder;

    GattRequest(String characteristicUUID, List<Field> fields) {
        if (fields.isEmpty()) {
            throw new IllegalArgumentException("Fields cannot be empty");
        }
        this.characteristicUUID = characteristicUUID;
        this.holders = this.getHolders(fields);
        this.opCodesHolder = this.findOpCodesField();
    }

    GattRequest(String characteristicUUID, Map<String, FieldHolder> holders) {
        if (holders.isEmpty()) {
            throw new IllegalArgumentException("Fields cannot be empty");
        }
        this.characteristicUUID = characteristicUUID;
        this.holders = new HashMap<String, FieldHolder>(holders);
        this.opCodesHolder = this.findOpCodesField();
    }

    public FieldHolder getOpCodesFieldHolder() {
        return this.opCodesHolder;
    }

    public boolean hasOpCodesField() {
        return this.opCodesHolder != null;
    }

    public void setField(String name, Boolean value) {
        this.validate(name);
        this.holders.get(name).setBoolean(value);
    }

    public void setField(String name, Integer value) {
        this.setField(name, FieldHolder::setInteger, value);
    }

    public void setField(String name, Long value) {
        this.setField(name, FieldHolder::setLong, value);
    }

    public void setField(String name, BigInteger value) {
        this.setField(name, FieldHolder::setBigInteger, value);
    }

    public void setField(String name, Float value) {
        this.setField(name, FieldHolder::setFloat, value);
    }

    public void setField(String name, Double value) {
        this.setField(name, FieldHolder::setDouble, value);
    }

    public void setField(String name, Enumeration value) {
        this.setField(name, FieldHolder::setEnumeration, value);
    }

    public void setField(String name, byte[] value) {
        this.setField(name, FieldHolder::setStruct, value);
    }

    public void setField(String name, String value) {
        this.setField(name, FieldHolder::setString, value);
    }

    public String getCharacteristicUUID() {
        return this.characteristicUUID;
    }

    public List<FieldHolder> getAllFieldHolders() {
        return new ArrayList<FieldHolder>(this.holders.values());
    }

    public List<FieldHolder> getRequiredFieldHolders() {
        FieldHolder controlPointField = this.getOpCodesFieldHolder();
        String requirement = controlPointField != null ? controlPointField.getEnumerationRequires() : null;
        ArrayList<FieldHolder> required = new ArrayList<FieldHolder>();
        required.addAll(this.getRequiredHolders("Mandatory"));
        if (requirement != null) {
            required.addAll(this.getRequiredHolders(requirement));
        }
        return Collections.unmodifiableList(required);
    }

    public FieldHolder getFieldHolder(String name) {
        this.validate(name);
        return this.holders.get(name);
    }

    public boolean hasFieldHolder(String name) {
        return this.holders.containsKey(name);
    }

    List<FieldHolder> getRequiredHolders(String requirement) {
        ArrayList<FieldHolder> result = new ArrayList<FieldHolder>();
        for (FieldHolder holder : this.holders.values()) {
            if (!holder.getField().getRequirements().contains(requirement)) continue;
            result.add(holder);
        }
        return result;
    }

    Map<String, FieldHolder> getHolders() {
        return this.holders;
    }

    private void validate(String name) {
        if (!this.holders.containsKey(name)) {
            throw new IllegalArgumentException("Unknown field: " + name);
        }
    }

    private FieldHolder findOpCodesField() {
        return this.holders.values().stream().filter(field -> FlagUtils.isOpCodesField(field.getField())).findFirst().orElse(null);
    }

    private Map<String, FieldHolder> getHolders(List<Field> fields) {
        LinkedHashMap<String, FieldHolder> result = new LinkedHashMap<String, FieldHolder>();
        for (Field field : fields) {
            result.put(field.getName(), new FieldHolder(field));
        }
        return Collections.unmodifiableMap(result);
    }

    private void setOpCode(List<String> requirements) {
        BitField bitField;
        if (requirements != null && !requirements.isEmpty() && this.opCodesHolder != null && (bitField = this.opCodesHolder.getField().getBitField()) == null) {
            requirements.stream().filter(req -> !"Mandatory".equalsIgnoreCase((String)req)).findFirst().ifPresent(requirement -> this.opCodesHolder.getField().getEnumerations().getEnumerations().stream().filter(enm -> requirement.equalsIgnoreCase(enm.getRequires())).findFirst().ifPresent(enm -> this.opCodesHolder.setBigInteger(enm.getKey())));
        }
    }

    private <T> void setField(String name, BiConsumer<FieldHolder, T> setter, T value) {
        this.validate(name);
        FieldHolder fieldHolder = this.holders.get(name);
        setter.accept(fieldHolder, (FieldHolder)value);
        this.setOpCode(fieldHolder.getField().getRequirements());
    }
}

