/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth.gattparser;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sputnikdev.bluetooth.gattparser.BluetoothGattParserFactory;
import org.sputnikdev.bluetooth.gattparser.CharacteristicFormatException;
import org.sputnikdev.bluetooth.gattparser.CharacteristicParser;
import org.sputnikdev.bluetooth.gattparser.FieldHolder;
import org.sputnikdev.bluetooth.gattparser.num.FloatingPointNumberFormatter;
import org.sputnikdev.bluetooth.gattparser.num.RealNumberFormatter;
import org.sputnikdev.bluetooth.gattparser.spec.BluetoothGattSpecificationReader;
import org.sputnikdev.bluetooth.gattparser.spec.Characteristic;
import org.sputnikdev.bluetooth.gattparser.spec.Field;
import org.sputnikdev.bluetooth.gattparser.spec.FieldFormat;
import org.sputnikdev.bluetooth.gattparser.spec.FieldType;
import org.sputnikdev.bluetooth.gattparser.spec.FlagUtils;

public class GenericCharacteristicParser
implements CharacteristicParser {
    private final Logger logger = LoggerFactory.getLogger(GenericCharacteristicParser.class);
    private final BluetoothGattSpecificationReader reader;

    GenericCharacteristicParser(BluetoothGattSpecificationReader reader) {
        this.reader = reader;
    }

    @Override
    public LinkedHashMap<String, FieldHolder> parse(Characteristic characteristic, byte[] raw) throws CharacteristicFormatException {
        LinkedHashMap<String, FieldHolder> result = new LinkedHashMap<String, FieldHolder>();
        this.validate(characteristic);
        int offset = 0;
        List<Field> fields = characteristic.getValue().getFields();
        Set<String> requires = FlagUtils.getReadFlags(fields, raw);
        requires.add("Mandatory");
        for (Field field : fields) {
            List<String> requirements = field.getRequirements();
            if (requirements != null && !requirements.isEmpty() && !requires.containsAll(requirements)) continue;
            if (field.getReference() != null) {
                LinkedHashMap<String, FieldHolder> subCharacteristic = this.parse(this.reader.getCharacteristicByType(field.getReference().trim()), this.getRemainder(raw, offset));
                result.putAll(subCharacteristic);
                int size = this.getSize(subCharacteristic.values());
                if (size == -1) break;
                offset += size;
                continue;
            }
            if (FlagUtils.isFlagsField(field)) {
                offset += field.getFormat().getSize();
                continue;
            }
            FieldFormat fieldFormat = field.getFormat();
            result.put(field.getName(), this.parseField(field, raw, offset));
            if (fieldFormat.getSize() == -1) break;
            offset += field.getFormat().getSize();
        }
        return result;
    }

    @Override
    public byte[] serialize(Collection<FieldHolder> fieldHolders) throws CharacteristicFormatException {
        byte[] byArray;
        BitSet bitSet = new BitSet();
        int offset = 0;
        for (FieldHolder holder : fieldHolders) {
            if (!holder.isValueSet()) continue;
            int size = holder.getField().getFormat().getSize();
            BitSet serialized = this.serialize(holder);
            if (size == -1) {
                size = serialized.length();
            }
            this.concat(bitSet, serialized, offset, size);
            offset += size;
        }
        if (bitSet.isEmpty()) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 0;
        } else {
            byArray = bitSet.toByteArray();
        }
        byte[] data = byArray;
        return data.length > 20 ? Arrays.copyOf(bitSet.toByteArray(), 20) : data;
    }

    Object parse(Field field, byte[] raw, int offset) {
        FieldFormat fieldFormat = field.getFormat();
        int size = fieldFormat.getSize();
        switch (fieldFormat.getType()) {
            case BOOLEAN: {
                return this.parseBoolean(raw, offset);
            }
            case UINT: {
                return this.deserializeReal(raw, offset, size, false);
            }
            case SINT: {
                return this.deserializeReal(raw, offset, size, true);
            }
            case FLOAT_IEE754: {
                return this.deserializeFloat(BluetoothGattParserFactory.getIEEE754FloatingPointNumberFormatter(), raw, offset, size);
            }
            case FLOAT_IEE11073: {
                return this.deserializeFloat(BluetoothGattParserFactory.getIEEE11073FloatingPointNumberFormatter(), raw, offset, size);
            }
            case UTF8S: {
                return this.deserializeString(raw, offset, "UTF-8");
            }
            case UTF16S: {
                return this.deserializeString(raw, offset, "UTF-16");
            }
            case STRUCT: {
                return BitSet.valueOf(raw).get(offset, offset + raw.length * 8).toByteArray();
            }
        }
        throw new IllegalStateException("Unsupported field format: " + (Object)((Object)fieldFormat.getType()));
    }

    BitSet serialize(boolean value) {
        BitSet bitSet = new BitSet();
        if (value) {
            bitSet.set(0);
        }
        return bitSet;
    }

    void concat(BitSet target, BitSet source, int offset, int size) {
        for (int i = 0; i < size; ++i) {
            if (!source.get(i)) continue;
            target.set(offset + i);
        }
    }

    private BitSet serialize(FieldHolder holder) {
        FieldFormat fieldFormat = holder.getField().getFormat();
        switch (fieldFormat.getType()) {
            case BOOLEAN: {
                return this.serialize(holder.getBoolean(null));
            }
            case UINT: 
            case SINT: {
                return this.serializeReal(holder);
            }
            case FLOAT_IEE754: {
                return this.serializeFloat(BluetoothGattParserFactory.getIEEE754FloatingPointNumberFormatter(), holder);
            }
            case FLOAT_IEE11073: {
                return this.serializeFloat(BluetoothGattParserFactory.getIEEE11073FloatingPointNumberFormatter(), holder);
            }
            case UTF8S: {
                return this.serializeString(holder, "UTF-8");
            }
            case UTF16S: {
                return this.serializeString(holder, "UTF-16");
            }
            case STRUCT: {
                return BitSet.valueOf((byte[])holder.getRawValue());
            }
        }
        throw new IllegalStateException("Unsupported field format: " + (Object)((Object)fieldFormat.getType()));
    }

    private Boolean parseBoolean(byte[] raw, int offset) {
        return BitSet.valueOf(raw).get(offset);
    }

    private FieldHolder parseField(Field field, byte[] raw, int offset) {
        FieldFormat fieldFormat = field.getFormat();
        if (fieldFormat.getSize() != -1 && offset + fieldFormat.getSize() > raw.length * 8) {
            throw new CharacteristicFormatException("Not enough bits to parse field \"" + field.getName() + "\". Data length: " + raw.length + " bytes. Looks like your device does not conform SIG specification.");
        }
        Object value = this.parse(field, raw, offset);
        return new FieldHolder(field, value);
    }

    private void validate(Characteristic characteristic) {
        if (!characteristic.isValidForRead()) {
            this.logger.error("Characteristic cannot be parsed: \"{}\".", (Object)characteristic.getName());
            throw new CharacteristicFormatException("Characteristic cannot be parsed: \"" + characteristic.getName() + "\".");
        }
    }

    private int getSize(Collection<FieldHolder> holders) {
        int size = 0;
        for (FieldHolder holder : holders) {
            Field field = holder.getField();
            if (field.getFormat().getSize() == -1) {
                return -1;
            }
            size += field.getFormat().getSize();
        }
        return size;
    }

    private BitSet serializeReal(FieldHolder holder) {
        boolean signed;
        RealNumberFormatter realNumberFormatter = BluetoothGattParserFactory.getTwosComplementNumberFormatter();
        int size = holder.getField().getFormat().getSize();
        boolean bl = signed = holder.getField().getFormat().getType() == FieldType.SINT;
        if (signed && size <= 32 || !signed && size < 32) {
            return realNumberFormatter.serialize((Integer)holder.getRawValue(), size, signed);
        }
        if (signed && size <= 64 || !signed && size < 64) {
            return realNumberFormatter.serialize((Long)holder.getRawValue(), size, signed);
        }
        return realNumberFormatter.serialize((BigInteger)holder.getRawValue(), size, signed);
    }

    private Object deserializeReal(byte[] raw, int offset, int size, boolean signed) {
        RealNumberFormatter realNumberFormatter = BluetoothGattParserFactory.getTwosComplementNumberFormatter();
        int toIndex = offset + size;
        if (signed && size <= 32 || !signed && size < 32) {
            return realNumberFormatter.deserializeInteger(BitSet.valueOf(raw).get(offset, toIndex), size, signed);
        }
        if (signed && size <= 64 || !signed && size < 64) {
            return realNumberFormatter.deserializeLong(BitSet.valueOf(raw).get(offset, toIndex), size, signed);
        }
        return realNumberFormatter.deserializeBigInteger(BitSet.valueOf(raw).get(offset, toIndex), size, signed);
    }

    private Object deserializeFloat(FloatingPointNumberFormatter formatter, byte[] raw, int offset, int size) {
        int toIndex = offset + size;
        if (size == 16) {
            return formatter.deserializeSFloat(BitSet.valueOf(raw).get(offset, toIndex));
        }
        if (size == 32) {
            return formatter.deserializeFloat(BitSet.valueOf(raw).get(offset, toIndex));
        }
        if (size == 64) {
            return formatter.deserializeDouble(BitSet.valueOf(raw).get(offset, toIndex));
        }
        throw new IllegalStateException("Unknown bit size for float numbers: " + size);
    }

    private BitSet serializeFloat(FloatingPointNumberFormatter formatter, FieldHolder holder) {
        int size = holder.getField().getFormat().getSize();
        if (size == 16) {
            return formatter.serializeSFloat(holder.getFloat(null));
        }
        if (size == 32) {
            return formatter.serializeFloat(holder.getFloat(null));
        }
        if (size == 64) {
            return formatter.serializeDouble(holder.getDouble(null));
        }
        throw new IllegalStateException("Invalid bit size for float numbers: " + size);
    }

    private String deserializeString(byte[] raw, int offset, String encoding) {
        try {
            return new String(BitSet.valueOf(raw).get(offset, offset + raw.length * 8).toByteArray(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private BitSet serializeString(FieldHolder holder, String encoding) {
        try {
            return BitSet.valueOf(holder.getString(null).getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] getRemainder(byte[] raw, int offset) {
        byte[] remained = BitSet.valueOf(raw).get(offset, raw.length * 8).toByteArray();
        byte[] remainedWithTrailingZeros = new byte[raw.length - (int)Math.ceil((double)offset / 8.0)];
        System.arraycopy(remained, 0, remainedWithTrailingZeros, 0, remained.length);
        return remainedWithTrailingZeros;
    }
}

